/*
     
*/
#include "solvers/svctx.h"
#include "solvers/svpriv.h"

/*@
   SVRegisterAll - This routine registers all the SERIAL linear system
  solvers in the SV package. 

  Note:
  To prevent all the solvers from being 
  registered and thus save memory, the user should copy this routine and 
  register only those solvers they desire.  Make sure that the
  replacement routine is linked in ahead of tools.a .
@*/
void SVRegisterAll()
{
  SVRegister((int)SVLU,    "lu",     SViCreateLU);
  SVRegister((int)SVJacobi,"jacobi", SViCreateJacobi);
  SVRegister((int)SVSSOR,  "ssor",   SViCreateSSOR); 
  SVRegister((int)SVILU,   "ilu",    SViCreateILU); 
  SVRegister((int)SVICC,   "icc",    SViCreateICC); 
  SVRegister((int)SVICCJP, "iccjp",  SViCreateICCJP); 
  SVRegister((int)SVBDD,   "bdd",    SViCreateBDD); 
  SVRegister((int)SVOSM,   "osm",    SViCreateOSM); 
  SVRegister((int)SVNOPRE, "nopre",  SViCreateNoPre);
}
