C SCCSID = "@(#)progdefs.inc    1.1 9/21/87"
C Depending on switches set in the ARFOR compiler, various versions of
C the FORTRAN source code will be written.  The three possibilities are
C a "utilization" version, with timing information only;
C a "monitoring" version, which includes timing and key iterates;
C and a "debugging" version, which includes communication monitoring
C and more iterate information.
C To do FORTRAN debugging using the VAX compiler and linker, a VAXONLY
C ARFOR switch is also included.
C An ARFOR definition file is included which contains all:
C (3) array declarators
C     (maximum of 31 interior grid points in each direction)
C     (maximum of 64 processors in square array)
C (4) boundary type indicators
C (5) direction codes
C (6) miscellaneous real constants
C (7) convergence flags
C====================================================================
      PROGRAM PCTEST
C--------------------------------------------------------------------
C PCTEST is a driver for debugging the PCGMR package.
C The system to be solved is:
C                            A x = b,
C in the form
C                            M x = f,
C where M = B^(-1) A, f = B^(-1)b.
C Matrix M is supplied in subroutine MATOP, called by PCGMR.
C This program performs initialization and post-processing.
C--------------------------------------------------------------------
C Arguments supplied to PCGMR at call:
C       N       system size
C [ Parallel Version: N is roughly the true size divided by P ]
C       M       maximum Krylov subspace dimension
C [ Parallel Version: M and related quantities are full-size ]
C       M1      maximum Krylov subspace dimension plus one
C       SOL     initial iterate of solution vector
C       RHS     vector of right-hand sides of linear system
C [ Parallel Version: SOL and RHS are the local pieces, and below ]
C       EPSREL  relative convergence tolerance
C       EPSABS  absolute convergence tolerance
C       EIGSKP  switch for skipping the eigenvalue estimation
C       MATOP   user-supplied matrix operator subroutine
C [ Parallel Version: user's AMULT and BSOLV take place within MATOP ]
C Arguments available from PCGMR upon return:
C       FLGSTP  termination code
C       SOL     final iterate of solution vector
C       VV      matrix of Krylov subspace vectors
C [ Parallel Version: VV is the local piece ]
C       ITS     counter for total iterations (incl. possible restarts)
C       HH      matrix of coefficients of solution with respect to V
C       CC      vector of cosines for QR least squares factorization
C       SS      vector of sines for QR least squares factorization
C       RS      vector of right-hand sides for least squares problem
C       WR      real parts of estimated eigenvalues
C       WI      imaginary parts of estimated eigenvalues
C Other arguments:
C       MSOL    working vector
C       SOLPL   working vector
C       HES     Hessenberg matrix for Jacobian eigenvalue estimation
C       BETA    residual norm for Jacobian eigenvalue estimation
C       ERES    residual of estimated spectrum
C       ZZ      working array for eigenvectors
C       IORD    working array for reordering of spectrum
C       IERR    error return indicator from SPCTRM
C--------------------------------------------------------------------
      INTEGER  N, M, M1, I, ITS, FLGSTP, IERR, OPTPRE, COUPLE, ORIENT
      INTEGER  SX, EX, SY, EY
      INTEGER  IARGC
      INTEGER  IORD(300)
      REAL*8   EPSREL, EPSABS, BETA
      COMMON /SHARE1/ H1(1024), F1, SOL, RHS, VV, MSOL, SOLPL, T1(1024)
      REAL*8   H1, F1, T1
      REAL*8   SOL(14283), RHS(14283), VV(14283,301), MSOL(14283), SOLPL
     *(14283)
      REAL*8   HH(301,300), CC(300), SS(300), RS(301), HES(300,300), WR(
     *300), WI(300), ERES(300), ZZ(300,300)
      LOGICAL  EIGSKP
      EXTERNAL MATOP
      REAL*8   RES, RESNRM
C--------------------------------------------------------------------
C SCCSID = "@(#)csystm.inc      1.2 11:28:49"
C       NX      grid resolution in X
C       NY      grid resolution in Y
C       NC      number of components per grid point
C       IPVT    pivot data for diagonal block factorization
C       A0,...  blocks of the nine-point linear operator
C       Q0,...  blocks of the nine-point ILU operator
C       B0      right-hand side of the linear operator
      INTEGER  NX, NY, NC, MODE, IPVT(14283)
      REAL*8   CONV
      REAL*8   A0(42849),  AN(42849),  AS(42849),  AE(42849),  AW(42849)
     *, ANE(42849), ANW(42849), ASE(42849), ASW(42849), Q0(42849),  QN(
     *42849),  QS(42849),  QE(42849),  QW(42849), QNE(42849), QNW(42849)
     *, QSE(42849), QSW(42849), B0(14283),  W1(14283),  W2(14283),  D0(
     *42849)
      COMMON  /CSYSTM/ NX, NY, NC, MODE, IPVT, CONV
C These variables need to be shared; in particular, the
C a. and q. are needed in applying amult along the borders of the domain
Cs.
      REAL*8  HEAD, FIRST, TAIL
      COMMON  /SHARE/ HEAD(1024), FIRST, A0, AN, AS, AE, AW, ANE, ANW,
     * ASE, ASW, Q0, QN, QS, QE, QW, QNE, QNW, QSE, QSW, B0, W1, W2, D0,
     * TAIL(1024)
      SAVE    /CSYSTM/
      SAVE    /SHARE/
C private data for parallel code
      INTEGER CMNP, CMNY, CMNX, CMMYID, BOUND(4)
      COMMON  /PRIATE/ CMNP, CMNY, CMNX, CMMYID, BOUND
C parallel programming data
      INTEGER NFORK
C routine to create parallel processes
      REAL    ETIME, TIM(2)
C for timing
      REAL    TIME1, TIME0
C--------------------------------------------------------------------
      INTEGER NJ, AGAIN
C input operator phase----------------------------------------------\
      CALL GETPUT( MODE, NX, NY, NC, CONV )
      N   = (NX + 2) * (NY + 2) * NC
      NJ  = N * NC
C end input phase------------------------------------------------------/
C enter while loop for different parameterizations with same matrix
      AGAIN   = 1
1     IF (AGAIN .EQ. 1) THEN
C initialization phase---------------------------------------------\
C initialization of GMR parameters
          CALL GETRUN( M, EPSREL, OPTPRE, COUPLE, ORIENT )
C open the appropriate file for the output
          CALL SETPUT( NX, CMNX, CMNY, COUPLE, OPTPRE )
          M1  = M + 1
          EPSABS = 1.0D-12
C !!!! here starts the parallel code
          CALL CINIT()
          CALL CSHARE( FIRST, 6855848 )
          CALL CSHARE( F1, 34850528 )
          CMMYID  = NFORK( CMNP )
          CALL GETOMP( NX, NY, SX, EX, SY, EY )
C make second, destroyable copy of coefficients for preconditioning use
          CALL MCOPY( NC*NC, NX, NY, A0, Q0, SX, EX, SY, EY )
          CALL MCOPY( NC*NC, NX, NY, AN, QN, SX, EX, SY, EY )
          CALL MCOPY( NC*NC, NX, NY, AS, QS, SX, EX, SY, EY )
          CALL MCOPY( NC*NC, NX, NY, AE, QE, SX, EX, SY, EY )
          CALL MCOPY( NC*NC, NX, NY, AW, QW, SX, EX, SY, EY )
          CALL MCOPY( NC*NC, NX, NY, ANE, QNE, SX, EX, SY, EY )
          CALL MCOPY( NC*NC, NX, NY, ANW, QNW, SX, EX, SY, EY )
          CALL MCOPY( NC*NC, NX, NY, ASE, QSE, SX, EX, SY, EY )
          CALL MCOPY( NC*NC, NX, NY, ASW, QSW, SX, EX, SY, EY )
          CALL SYNC()
          TIME0   = ETIME( TIM )
C initialization of preconditioning options and work arrays
C (user-routine MATOP does preconditioning preprocessing (including
C modification of RHS with left-preconditioning, if necessary) and
C initializes the solution vector when called with its first argument
C negative)
          CALL MATOP( -OPTPRE, COUPLE, ORIENT, SX, EX, SY, EY, SOL, RHS
     *     )
C end initialization phase------------------------------------------/
C main iteration----------------------------------------------------\
          CALL PCGMR( N, NC, NX, NY, SX, EX, SY, EY, M, M1, SOL, RHS,
     *     EPSREL, EPSABS, MATOP, OPTPRE, COUPLE, ORIENT, VV, HH, CC, SS
     *    , RS, ITS, MSOL, SOLPL, HES, BETA, FLGSTP )
          TIME1   = ETIME( TIM ) - TIME0
          CALL NJOIN( CMMYID, CMNP )
C !!!! here ends the parallel code
          PRINT *, FLGSTP
C end main ---------------------------------------------------------/
C termination phase-------------------------------------------------\
C find approximation to spectrum of (preconditioned) matrix operator
C (this block may be skipped for timing studies; set EIGSKP to TRUE)
          IF ( .NOT.EIGSKP ) THEN
              CALL SPCTRM( M, ITS, HES, BETA, WR, WI, ERES, ZZ, IORD,
     *         IERR )
              CALL EIGPRT( 3, ITS, IERR, WR, WI, ERES )
C find the true residual at convergence (based on prec. residual)
C SOL contains solution, B0 the rhs, and MSOL is a work array
          ENDIF
          CALL RESID( NC, NX, NY, RES, RESNRM, SOL, B0, A0, AN, AS, AE,
     *     AW, ANE, ANW, ASE, ASW )
          PRINT *, 'True residual = ', RES, ' normalized =', RESNRM
C timing data for parallel portion (including GMR/ILU/MSC preproc.)
          PRINT *, 'Time to solve = ', TIME1, 'seconds'
          CALL DOOPUT( NX, CONV, CMNX, CMNY, COUPLE, OPTPRE, ITS, TIME1,
     *     RES )
          CALL TSTPRT( 2, I, ITS, FLGSTP, N, RESNRM, SOL, IERR )
C end termination phase---------------------------------------------/
          IF (IARGC() .GT. 0) THEN
              AGAIN = 0
          ELSE
              PRINT *,
     *         'Do you wish to repeat with the same matrix? (0 for no)'
              READ (*, *, ERR=10) AGAIN
          ENDIF
C end case repeat loop
      GOTO 1
      ENDIF
      STOP
10    CONTINUE
      PRINT *, ' Error in input.  Re-run pctest and try again'
      STOP
      END
C======================================================================
      SUBROUTINE SPCTRM( M, I, HES, BETA, WR, WI, ERES, ZZ, IORD, IERR )
C----------------------------------------------------------------------
C SPCTRM estimates the spectrum of the (preconditioned) matrix operator
C as a by product of the Arnoldi process in the PCGMR iterations.
C (adapted from the work of Youcef Saad by David Keyes, July, 1986)
C--------------------------------------------------------------------
C Arguments required on input:
C       M       maximum Krylov subspace dimension
C       I       actual Krylov dimension
C       HES     Hessenberg matrix from Arnoldi process
C       BETA    inner iteration residual
C       ZZ      eigenvector workspace
C       IORD    permutation vector workspace
C Arguments available on output:
C       WR,WI   estimated real and imaginary parts of eigenvalues
C       ERES    residuals of eigenvalue estimates
C       IERR    error return from EISPAK routine HQR2
C--------------------------------------------------------------------
      INTEGER  M, I, IERR, IORD(M)
      REAL*8   HES(M,M), BETA, WR(M), WI(M), ERES(M), ZZ(M,M)
C--------------------------------------------------------------------
C Local variables:
C       II, JJ  dummy indices
C--------------------------------------------------------------------
      INTEGER  II, JJ
C initialize eigenvector matrix to identity for HQR2 input
      DO 1 II = 1, I
          DO 3 JJ = 1, I
              ZZ(II,JJ) = 0.0D0
3         CONTINUE
          ZZ(II,II) = 1.0D0
1     CONTINUE
C call EISPAK HQR2 for spectrum and eigenvectors of Hessenberg
      CALL HQR2( M, I, 1, I, HES, WR, WI, ZZ, IERR )
      IF ( IERR .NE. 0 ) THEN
          PRINT *, 'ERROR ', IERR, ' in HQR2 call in SPCTRM'
          RETURN
      ENDIF
      CALL RESIDL( I, ZZ, M, BETA, ERES, WI )
C reorder the spectrum, in order of reliability of estimate
      DO 5 II=1, I
          IORD(II) = II
5     CONTINUE
      CALL ORDRS( I, WR, WI, IORD, ERES )
      RETURN
      END
C====================================================================
      SUBROUTINE EIGPRT( MODE, I, IERR, WR, WI, ERES )
C--------------------------------------------------------------------
C EIGPRT prints estimated spectrum of (preconditioned) operator.
C--------------------------------------------------------------------
C Arguments on input:
C       MODE     print code
C                 ("3" spectrum)
C       I        dimension of Krylov subspace
C       IERR     error code from RG, for incomplete spectrum
C       WR       real parts of eigenvalues from RG
C       WI       imaginary parts of eigenvalues from RG
C       ERES     residual of estimated spectrum
C--------------------------------------------------------------------
      INTEGER  MODE, I, IERR
      REAL*8   WR(*), WI(*), ERES(*)
C--------------------------------------------------------------------
C Local variables:
C--------------------------------------------------------------------
      INTEGER  J
C--------------------------------------------------------------------
      IF (MODE .GE. 2) THEN
          WRITE(6,3001) I
          DO 1 J = IERR+1, I
              WRITE(6,1001) J, WR(J), WI(J), ERES(J)
1         CONTINUE
      ENDIF
      RETURN
1001  FORMAT(I6,3E15.6)
3001  FORMAT(/' Spectrum of (preconditioned) system at step', I4, /
     *' INDEX           REAL           IMAG   EST. RESIDUAL')
      END
C====================================================================
      SUBROUTINE REASYS( FNAME )
C----------------------------------------------------------------------
C REASYS  reads the linear operator coefficients from a disk file.
C The data must be written in the order and format used below.
C (anonical order: a0,an,as,ae,aw,ane,anw,ase,asw)
C----------------------------------------------------------------------
      CHARACTER*(*)   FNAME
C SCCSID = "@(#)csystm.inc      1.2 11:28:49"
C       NX      grid resolution in X
C       NY      grid resolution in Y
C       NC      number of components per grid point
C       IPVT    pivot data for diagonal block factorization
C       A0,...  blocks of the nine-point linear operator
C       Q0,...  blocks of the nine-point ILU operator
C       B0      right-hand side of the linear operator
      INTEGER  NX, NY, NC, MODE, IPVT(14283)
      REAL*8   CONV
      REAL*8   A0(42849),  AN(42849),  AS(42849),  AE(42849),  AW(42849)
     *, ANE(42849), ANW(42849), ASE(42849), ASW(42849), Q0(42849),  QN(
     *42849),  QS(42849),  QE(42849),  QW(42849), QNE(42849), QNW(42849)
     *, QSE(42849), QSW(42849), B0(14283),  W1(14283),  W2(14283),  D0(
     *42849)
      COMMON  /CSYSTM/ NX, NY, NC, MODE, IPVT, CONV
C These variables need to be shared; in particular, the
C a. and q. are needed in applying amult along the borders of the domain
Cs.
      REAL*8  HEAD, FIRST, TAIL
      COMMON  /SHARE/ HEAD(1024), FIRST, A0, AN, AS, AE, AW, ANE, ANW,
     * ASE, ASW, Q0, QN, QS, QE, QW, QNE, QNW, QSE, QSW, B0, W1, W2, D0,
     * TAIL(1024)
      SAVE    /CSYSTM/
      SAVE    /SHARE/
C----------------------------------------------------------------------
      INTEGER NE, NJ, I
      OPEN(UNIT=22, FILE=FNAME, STATUS='old', ERR=10)
      READ (22,*,ERR=20)  NX, NY, NC
      CALL REASY1( NC, NX, NY, A0, AN, AS, AE, AW, ANE, ANW, ASE, ASW,
     * B0 )
      CLOSE(UNIT=22)
      RETURN
10    CONTINUE
      PRINT *, 'Error opening file for matrix and rhs'
      STOP
20    CONTINUE
      PRINT *, 'Error reading problem size from file'
      STOP
      END
C====================================================================
      SUBROUTINE REASY1( NC, NX, NY, A0, AN, AS, AE, AW, ANE, ANW, ASE,
     * ASW, B0 )
C----------------------------------------------------------------------
C REASYS  reads the linear operator coefficients from a disk file.
C The data must be written in the order and format used below.
C (anonical order: a0,an,as,ae,aw,ane,anw,ase,asw)
C----------------------------------------------------------------------
C----------------------------------------------------------------------
      INTEGER  NC, NX, NY
      REAL*8   A0(NC,NC,0:NX+1,0:NY+1), AN(NC,NC,0:NX+1,0:NY+1), AS(NC,
     *NC,0:NX+1,0:NY+1), AE(NC,NC,0:NX+1,0:NY+1), AW(NC,NC,0:NX+1,0:NY+1
     *), ANE(NC,NC,0:NX+1,0:NY+1), ANW(NC,NC,0:NX+1,0:NY+1), ASE(NC,NC,0
     *:NX+1,0:NY+1), ASW(NC,NC,0:NX+1,0:NY+1)
      REAL*8   B0(NC,0:NX+1,0:NY+1)
C----------------------------------------------------------------------
      INTEGER NE, NJ, I, J, K, L
      NE  = (NX + 2) * (NY + 2) * NC
      NJ  = NE * NC
C zero out coefficient arrays
      CALL DSCAL( NJ, 0.0D0, A0, 1 )
      CALL DSCAL( NJ, 0.0D0, AN, 1 )
      CALL DSCAL( NJ, 0.0D0, AS, 1 )
      CALL DSCAL( NJ, 0.0D0, AE, 1 )
      CALL DSCAL( NJ, 0.0D0, AW, 1 )
      CALL DSCAL( NJ, 0.0D0, ANE, 1 )
      CALL DSCAL( NJ, 0.0D0, ANW, 1 )
      CALL DSCAL( NJ, 0.0D0, ASE, 1 )
      CALL DSCAL( NJ, 0.0D0, ASW, 1 )
      CALL DSCAL( NE, 0.0D0, B0, 1 )
      READ (22,*,ERR=10)  ((((A0( K,L,I,J), K=1,NC), L=1,NC), I=1,NX), J
     *=1,NY)
      READ (22,*,ERR=10)  ((((AN( K,L,I,J), K=1,NC), L=1,NC), I=1,NX), J
     *=1,NY)
      READ (22,*,ERR=10)  ((((AS( K,L,I,J), K=1,NC), L=1,NC), I=1,NX), J
     *=1,NY)
      READ (22,*,ERR=10)  ((((AE( K,L,I,J), K=1,NC), L=1,NC), I=1,NX), J
     *=1,NY)
      READ (22,*,ERR=10)  ((((AW( K,L,I,J), K=1,NC), L=1,NC), I=1,NX), J
     *=1,NY)
      READ (22,*,ERR=10)  ((((ANE(K,L,I,J), K=1,NC), L=1,NC), I=1,NX), J
     *=1,NY)
      READ (22,*,ERR=10)  ((((ANW(K,L,I,J), K=1,NC), L=1,NC), I=1,NX), J
     *=1,NY)
      READ (22,*,ERR=10)  ((((ASE(K,L,I,J), K=1,NC), L=1,NC), I=1,NX), J
     *=1,NY)
      READ (22,*,ERR=10)  ((((ASW(K,L,I,J), K=1,NC), L=1,NC), I=1,NX), J
     *=1,NY)
      READ (22,*,ERR=10)  (((B0( L,I,J), L=1,NC), I=1,NX), J=1,NY)
      RETURN
10    CONTINUE
      PRINT *, 'Error reading matrix or rhs'
      STOP
      END
C======================================================================
      SUBROUTINE GENSYS
C----------------------------------------------------------------------
C GENSYS supplies the matrix and right-hand side of the linear system.
C These may be generated locally, or read from disk files.
C GENSYS also communicates the blocking of these arrays, stored into
C /CSYSTM/ COMMON for the routines MATOP and RHSOP, which in turn
C partition them into useful dimensioning for the AMULT and BSOLV
C routines.
C----------------------------------------------------------------------
C SCCSID = "@(#)csystm.inc      1.2 11:28:49"
C       NX      grid resolution in X
C       NY      grid resolution in Y
C       NC      number of components per grid point
C       IPVT    pivot data for diagonal block factorization
C       A0,...  blocks of the nine-point linear operator
C       Q0,...  blocks of the nine-point ILU operator
C       B0      right-hand side of the linear operator
      INTEGER  NX, NY, NC, MODE, IPVT(14283)
      REAL*8   CONV
      REAL*8   A0(42849),  AN(42849),  AS(42849),  AE(42849),  AW(42849)
     *, ANE(42849), ANW(42849), ASE(42849), ASW(42849), Q0(42849),  QN(
     *42849),  QS(42849),  QE(42849),  QW(42849), QNE(42849), QNW(42849)
     *, QSE(42849), QSW(42849), B0(14283),  W1(14283),  W2(14283),  D0(
     *42849)
      COMMON  /CSYSTM/ NX, NY, NC, MODE, IPVT, CONV
C These variables need to be shared; in particular, the
C a. and q. are needed in applying amult along the borders of the domain
Cs.
      REAL*8  HEAD, FIRST, TAIL
      COMMON  /SHARE/ HEAD(1024), FIRST, A0, AN, AS, AE, AW, ANE, ANW,
     * ASE, ASW, Q0, QN, QS, QE, QW, QNE, QNW, QSE, QSW, B0, W1, W2, D0,
     * TAIL(1024)
      SAVE    /CSYSTM/
      SAVE    /SHARE/
C----------------------------------------------------------------------
      INTEGER NE, NJ
      NE  = (NX + 2) * (NY + 2) * NC
      NJ  = NE * NC
C zero out coefficient arrays
      CALL DSCAL( NJ, 0.0D0, A0, 1 )
      CALL DSCAL( NJ, 0.0D0, AN, 1 )
      CALL DSCAL( NJ, 0.0D0, AS, 1 )
      CALL DSCAL( NJ, 0.0D0, AE, 1 )
      CALL DSCAL( NJ, 0.0D0, AW, 1 )
      CALL DSCAL( NJ, 0.0D0, ANE, 1 )
      CALL DSCAL( NJ, 0.0D0, ANW, 1 )
      CALL DSCAL( NJ, 0.0D0, ASE, 1 )
      CALL DSCAL( NJ, 0.0D0, ASW, 1 )
C set nonzero coefficients
      CALL AGEN( NX, NY, NC, MODE, A0, AN, AS, AE, AW, ANE, ANW, ASE,
     * ASW, CONV )
C set right-hand side
      CALL DSCAL( NE, 0.0D0, B0, 1 )
      CALL BGEN( NX, NY, NC, MODE, B0 )
      RETURN
      END
C======================================================================
      SUBROUTINE BGEN( NX, NY, NC, MODE, X )
C----------------------------------------------------------------------
C BGEN puts the right-hand side vector in X.
C----------------------------------------------------------------------
C Arguments required on input:
C       NX      grid resolution in X
C       NY      grid resolution in Y
C       NC      number of components
C Arguments available on output:
C       X       right-hand side
C----------------------------------------------------------------------
      INTEGER  NX, NY, NC, MODE
      REAL*8   X(NC,0:NX+1,0:NY+1)
C----------------------------------------------------------------------
C Local variables:
C       i, j, k dummy indices
C----------------------------------------------------------------------
      INTEGER  I, J, K
C----------------------------------------------------------------------
      I = 1
      DO 1 J = 1, NY
          DO 3 K = 1, NC
              X(K,I,J) = 0.0D0
3         CONTINUE
1     CONTINUE
      DO 5 I = 2, NX-1
          J = 1
          DO 7 K = 1, NC
              X(K,I,J) = 0.0D0
7         CONTINUE
          DO 9 J = 2, NY-1
              DO 11 K = 1, NC
                  X(K,I,J) = 1.0D0
11            CONTINUE
9         CONTINUE
          J = NY
          DO 13 K = 1, NC
              X(K,I,J) = 0.0D0
13        CONTINUE
5     CONTINUE
      I = NX
      DO 15 J = 1, NY
          DO 17 K = 1, NC
              X(K,I,J) = 0.0D0
17        CONTINUE
15    CONTINUE
C remove forcing term from higher-order systems if MODE < 0
      IF (NC .GT. 1 .AND. MODE .LT. 0) THEN
          DO 19 I = 2, NX-1
              DO 21 J = 2, NY-1
                  DO 23 K = 2, NC
                      X(K,I,J) = 0.0D0
23                CONTINUE
21            CONTINUE
19        CONTINUE
C add vertical (S to N) convection if MODE = +1
      ENDIF
      IF (MODE .EQ. 1) THEN
          J = 1
          DO 25 I = 2, NX-1
              DO 27 K = 1, NC
                  X(K,I,J) = 1.0D0
27            CONTINUE
25        CONTINUE
C add horizontal (W to E) convection if MODE = +2
      ENDIF
      IF (MODE .EQ. 2) THEN
          I = 1
          DO 29 J = 2, NY-1
              DO 31 K = 1, NC
                  X(K,I,J) = 1.0D0
31            CONTINUE
29        CONTINUE
C add vertical (N to S) convection if MODE = +3
      ENDIF
      IF (MODE .EQ. 3) THEN
          J = NY
          DO 33 I = 2, NX-1
              DO 35 K = 1, NC
                  X(K,I,J) = 1.0D0
35            CONTINUE
33        CONTINUE
C add horizontal (E to W) convection if MODE = +4
      ENDIF
      IF (MODE .EQ. 4) THEN
          I = NX
          DO 37 J = 2, NY-1
              DO 39 K = 1, NC
                  X(K,I,J) = 1.0D0
39            CONTINUE
37        CONTINUE
C----------------------------------------------------------------------
      ENDIF
      RETURN
      END
C======================================================================
      SUBROUTINE AGEN( NX, NY, NC, MODE, A0, AN, AS, AE, AW, ANE, ANW,
     * ASE, ASW, CONV )
C----------------------------------------------------------------------
C AGEN puts the right-hand side vector in X.
C Assumed at start that everything is zeroed.
C----------------------------------------------------------------------
C Arguments required on input:
C       NX      grid resolution in X
C       NY      grid resolution in Y
C       NC      number of components
C       MODE    specifies presence or absence of coupling and convection
C       CONV    specifies magnitude of convection (if MODE = 1)
C Arguments available on output:
C       A0,..   Jacobian blocks
C----------------------------------------------------------------------
      INTEGER  NX, NY, NC, MODE
      REAL*8   A0(NC,NC,0:NX+1,0:NY+1), AN(NC,NC,0:NX+1,0:NY+1), AS(NC,
     *NC,0:NX+1,0:NY+1), AE(NC,NC,0:NX+1,0:NY+1), AW(NC,NC,0:NX+1,0:NY+1
     *), ANE(NC,NC,0:NX+1,0:NY+1), ANW(NC,NC,0:NX+1,0:NY+1), ASE(NC,NC,0
     *:NX+1,0:NY+1), ASW(NC,NC,0:NX+1,0:NY+1), CONV
C----------------------------------------------------------------------
C Local variables:
C       i, j, k dummy indices
C----------------------------------------------------------------------
      INTEGER  I, J, K
      REAL*8   RH, RHSQ
C----------------------------------------------------------------------
      RH   = FLOAT( NX - 1 )
      RHSQ = RH ** 2
      I = 1
      DO 1 J = 1, NY
          DO 3 K = 1, NC
              A0(K,K,I,J) = 1.0D0
3         CONTINUE
1     CONTINUE
      DO 5 I = 2, NX-1
          J = 1
          DO 7 K = 1, NC
              A0(K,K,I,J) = 1.0D0
7         CONTINUE
          DO 9 J = 2, NY-1
              DO 11 K = 1, NC
C            a0(k,k,i,j) = four * rhsq
C            an(k,k,i,j) = -one * rhsq
C            as(k,k,i,j) = -one * rhsq
C            ae(k,k,i,j) = -one * rhsq
C            aw(k,k,i,j) = -one * rhsq
                  A0(K,K,I,J)  = 20./6. * RHSQ
                  AN(K,K,I,J)  = -4./6. * RHSQ
                  AS(K,K,I,J)  = -4./6. * RHSQ
                  AE(K,K,I,J)  = -4./6. * RHSQ
                  AW(K,K,I,J)  = -4./6. * RHSQ
                  ANE(K,K,I,J) = -1./6. * RHSQ
                  ANW(K,K,I,J) = -1./6. * RHSQ
                  ASE(K,K,I,J) = -1./6. * RHSQ
                  ASW(K,K,I,J) = -1./6. * RHSQ
11            CONTINUE
9         CONTINUE
          J = NY
          DO 13 K = 1, NC
              A0(K,K,I,J) = 1.0D0
13        CONTINUE
5     CONTINUE
      I = NX
      DO 15 J = 1, NY
          DO 17 K = 1, NC
              A0(K,K,I,J) = 1.0D0
17        CONTINUE
15    CONTINUE
C couple the higher-order systems if MODE = -1
      IF (NC .GT. 1 .AND. MODE .LT. 0) THEN
          DO 19 I = 2, NX-1
              DO 21 J = 2, NY-1
                  DO 23 K = 2, NC
                      A0(K,K-1,I,J)  = -1.0D0
23                CONTINUE
21            CONTINUE
19        CONTINUE
C add vertical (S to N) convection if MODE = +1
      ENDIF
      IF (MODE .EQ. 1) THEN
          DO 25 I = 2, NX-1
              DO 27 J = 2, NY-1
                  DO 29 K = 1, NC
                      A0(K,K,I,J)  = A0(K,K,I,J) + CONV * 2.0D0 * RHSQ
                      AS(K,K,I,J)  = AS(K,K,I,J) - CONV * 2.0D0 * RHSQ
29                CONTINUE
27            CONTINUE
25        CONTINUE
          J = NY
          DO 31 I = 2, NX-1
              DO 33 K = 1, NC
                  A0(K,K,I,J) = 1.0D0 * RH
                  AS(K,K,I,J) = - 1.0D0 * RH
33            CONTINUE
31        CONTINUE
C add horizontal (W to E) convection if MODE = +2
      ENDIF
      IF (MODE .EQ. 2) THEN
          DO 35 I = 2, NX-1
              DO 37 J = 2, NY-1
                  DO 39 K = 1, NC
                      A0(K,K,I,J)  = A0(K,K,I,J) + CONV * 2.0D0 * RHSQ
                      AW(K,K,I,J)  = AW(K,K,I,J) - CONV * 2.0D0 * RHSQ
39                CONTINUE
37            CONTINUE
35        CONTINUE
          I = NX
          DO 41 J = 2, NY-1
              DO 43 K = 1, NC
                  A0(K,K,I,J) = 1.0D0 * RH
                  AW(K,K,I,J) = - 1.0D0 * RH
43            CONTINUE
41        CONTINUE
C add vertical (N to S) convection if MODE = +3
      ENDIF
      IF (MODE .EQ. 3) THEN
          DO 45 I = 2, NX-1
              DO 47 J = 2, NY-1
                  DO 49 K = 1, NC
                      A0(K,K,I,J)  = A0(K,K,I,J) + CONV * 2.0D0 * RHSQ
                      AN(K,K,I,J)  = AN(K,K,I,J) - CONV * 2.0D0 * RHSQ
49                CONTINUE
47            CONTINUE
45        CONTINUE
          J = 1
          DO 51 I = 2, NX-1
              DO 53 K = 1, NC
                  A0(K,K,I,J) = 1.0D0 * RH
                  AN(K,K,I,J) = - 1.0D0 * RH
53            CONTINUE
51        CONTINUE
C add horizontal (E to W) convection if MODE = +4
      ENDIF
      IF (MODE .EQ. 4) THEN
          DO 55 I = 2, NX-1
              DO 57 J = 2, NY-1
                  DO 59 K = 1, NC
                      A0(K,K,I,J)  = A0(K,K,I,J) + CONV * 2.0D0 * RHSQ
                      AE(K,K,I,J)  = AE(K,K,I,J) - CONV * 2.0D0 * RHSQ
59                CONTINUE
57            CONTINUE
55        CONTINUE
          I = 1
          DO 61 J = 2, NY-1
              DO 63 K = 1, NC
                  A0(K,K,I,J) = 1.0D0 * RH
                  AE(K,K,I,J) = - 1.0D0 * RH
63            CONTINUE
61        CONTINUE
C----------------------------------------------------------------------
      ENDIF
      RETURN
      END
C======================================================================
      SUBROUTINE GETPUT( MODE, NX, NY, NC, CONV )
      INTEGER MODE, NX, NY, NC
      DOUBLE PRECISION CONV
      CHARACTER*20    STR
      INTEGER         IARGC
      CHARACTER*63    FNAME
      IF (IARGC() .GE. 1) THEN
          CALL GETARG( 1, STR )
          READ( STR, '(i20)', ERR=10) MODE
          CALL GETARG( 2, STR )
          READ( STR, '(i20)', ERR=10) NX
          CALL GETARG( 3, STR )
          READ( STR, '(i20)', ERR=10) NY
          CALL GETARG( 4, STR )
          READ( STR, '(i20)', ERR=10) NC
          CALL GETARG( 5, STR )
          READ( STR, '(f20.2)', ERR=10) CONV
          CALL GETARG( 6, FNAME )
          IF (FNAME(1:1) .EQ. '0') THEN
              CALL GENSYS
          ELSE
              CALL REASYS( FNAME )
          ENDIF
          RETURN
      ENDIF
      PRINT *, 'Give 0 to generate system internally or 1 to read in'
      READ  (*, *, ERR=10) MODE
      IF (MODE .EQ. 0) THEN
C read user input on problem size
          PRINT *,
     *     'Give number of gridpoints per side (subintervals plus one)'
          READ(*, *, ERR=10) NX
          NY  = NX
          PRINT *, 'Give number of unknowns per gridpoint'
          READ (*, *, ERR=10) NC
          PRINT *, 'Give mode of coupling'
          PRINT *,
     *     '    (if MODE is nonnegative, systems are independent)'
          PRINT *, '    (if MODE is one, a convection term is added)'
          PRINT *, '    (if MODE is negative, systems are coupled, with'
          PRINT *, '    NC=2 this is the biharmonic, etc.)'
          READ (*, *, ERR=10) MODE
          IF (MODE .GT. 0) THEN
              PRINT *,
     *         'Give magnitude of convection, relative to diffusion'
              PRINT *,
     *'(if CONV = 1.0, the diagonal contributions of each are equal)'
              READ (*, *, ERR=10) CONV
C initialization of linear system parameters
C (user-routine GENSYS has access to CSYSTM common)
          ENDIF
          CALL GENSYS
      ELSE
          PRINT *, 'What file for input?'
          READ (*, '(a)', ERR=10) FNAME
          CALL REASYS( FNAME )
      ENDIF
      RETURN
10    CONTINUE
      PRINT *, ' Error in input.  Re-run pctest and try again'
      STOP
      END
C======================================================================
      SUBROUTINE GETRUN( M, EPSREL, OPTPRE, COUPLE, ORIENT )
      INTEGER M, OPTPRE, COUPLE, ORIENT
      DOUBLE PRECISION EPSREL
C private data for parallel code
      INTEGER CMNP, CMNY, CMNX, CMMYID, BOUND(4)
      COMMON  /PRIATE/ CMNP, CMNY, CMNX, CMMYID, BOUND
C parallel programming data
      INTEGER IARGC
      CHARACTER*20    STR
      IF (IARGC() .GT. 6) THEN
          CALL GETARG( 7, STR )
          READ( STR, '(i20)', ERR=10 ) CMNX
          CALL GETARG( 8, STR )
          READ( STR, '(i20)', ERR=10 ) CMNY
          CMNP    = CMNX * CMNY
          CALL GETARG( 9, STR )
          READ( STR, '(i20)', ERR=10 ) M
          CALL GETARG( 10, STR )
          READ( STR, '(f20.2)', ERR=10 ) EPSREL
          CALL GETARG( 11, STR )
          READ( STR, '(i20)', ERR=10) COUPLE
          CALL GETARG( 12, STR )
          READ( STR, '(i20)', ERR=10) OPTPRE
          CALL GETARG( 13, STR )
          READ( STR, '(i20)', ERR=10) ORIENT
Cprint *, 'CMnx      = ', CMnx
Cprint *, 'CMny      = ', CMny
Cprint *, 'm         = ', m
Cprint *, 'epsrel    = ', epsrel
Cprint *, 'couple    = ', couple
Cprint *, 'optpre    = ', optpre
Cprint *, 'orient    = ', orient
          RETURN
      ENDIF
      PRINT *, 'Give number of processors in x and y'
      READ (*, *, ERR=10) CMNX, CMNY
      CMNP    = CMNX * CMNY
C CMmyid returned by nfork
C initialization of GMR parameters
      PRINT *, 'Give maximum size of Krylov subspace'
      READ ( *, *, ERR=10) M
      PRINT *, 'Give convergence criterion'
      READ ( *, *, ERR=10) EPSREL
      PRINT *, 'Give couple value (0 == none)'
      READ ( *, *, ERR=10) COUPLE
C initialization of preconditioning options and work arrays
C (user-routine MATOP does preconditioning preprocessing (including
C modification of RHS with left-preconditioning, if necessary) and
C initializes the solution vector when called with its first argument
C negative)
      PRINT *, 'Give preconditioning option (1=none,2=jac,3=ssor,4=ilu)'
      READ ( *, *, ERR=10) OPTPRE
      PRINT *, 'Give orientation option (1=left,2=right)'
      READ ( *, *, ERR=10) ORIENT
      RETURN
10    CONTINUE
      PRINT *, ' Error in input.  Re-run pctest and try again'
      STOP
      END
C======================================================================
      SUBROUTINE RESID( NC, NX, NY, RES, RESNRM, X, B0, A0, AN, AS, AE,
     * AW, ANE, ANW, ASE, ASW )
C----------------------------------------------------------------------
C RESID computes the unpreconditioned residual.
C----------------------------------------------------------------------
C Arguments required on input:
C       NC      number of components
C       NX      grid resolution in X
C       NY      grid resolution in Y
C       X       final iterate
C       B0      right-hand side
C       A0,...  coefficient arrays
C Arguments available on output:
C       RES     2-norm of residual
C       RESNRM  normalized 2-norm of residual
C----------------------------------------------------------------------
      INTEGER  NC, NX, NY
      REAL*8   RES, RESNRM
      REAL*8   X(NC,0:NX+1,0:NY+1), B0(NC,0:NX+1,0:NY+1)
      REAL*8   A0(NC,NC,0:NX+1,0:NY+1), AN(NC,NC,0:NX+1,0:NY+1), AS(NC,
     *NC,0:NX+1,0:NY+1), AE(NC,NC,0:NX+1,0:NY+1), AW(NC,NC,0:NX+1,0:NY+1
     *), ANE(NC,NC,0:NX+1,0:NY+1), ANW(NC,NC,0:NX+1,0:NY+1), ASE(NC,NC,0
     *:NX+1,0:NY+1), ASW(NC,NC,0:NX+1,0:NY+1)
C----------------------------------------------------------------------
      INTEGER  I, J, K, L
      REAL*8   TEMP
      RES = 0.0D0
      DO 1 J = 1, NY
          DO 3 I = 1, NX
              DO 5 K = 1, NC
                  TEMP = 0.0D0
                  DO 7 L = 1, NC
                      TEMP = TEMP + A0(K,L,I,J)  * X(L,I,J) + AW(K,L,I,J
     *                )  * X(L,I-1,J) + AE(K,L,I,J)  * X(L,I+1,J) + AS(K
     *                ,L,I,J)  * X(L,I,J-1) + AN(K,L,I,J)  * X(L,I,J+1)
     *                 + ASW(K,L,I,J) * X(L,I-1,J-1) + ASE(K,L,I,J) * X(
     *                L,I+1,J-1) + ANW(K,L,I,J) * X(L,I-1,J+1) + ANE(K,L
     *                ,I,J) * X(L,I+1,J+1)
7                 CONTINUE
                  RES = RES + ( B0(K,I,J) - TEMP ) ** 2
5             CONTINUE
3         CONTINUE
1     CONTINUE
      RES     = DSQRT( RES )
      RESNRM  = RES / DSQRT( DBLE( NC*NX*NY ) )
C----------------------------------------------------------------------
      RETURN
      END
C DOOUTPUT = DOOPUT
C SETOUTPUT = SETPUT
C GETINPUT = GETPUT
C PRIVATE = PRIATE
C GETDECOMP = GETOMP
