
/*   Utility routines used by the document preparation system.     */

#include "tools.h"
#include "system/system.h"
#include <string.h>
#include "doc/doc.h"

/* SubClass is the character after the KIND specifier */
static char SubClass;

char GetSubClass()
{
return SubClass;
}

/* Find a (non-alphanumeric) delimited token ----------------------*/
void FindToken( fd, token )
FILE *fd;
char *token;
{
int c;

c = getc( fd );
SubClass = c;

while ((c = getc( fd )) != EOF)
    if (isalpha(c)) break;
*token++ = c;
while ((c = getc( fd )) != EOF) 
    if (!isspace(c)) *token++ = c;
    else break;
*token++ = '\0';
}

/* Find the next space delimited token; put the text into token.
   The number of leading spaces is kept in nsp */
int FindNextToken( fd, token, nsp )
FILE *fd;
char *token;
int  *nsp;
{
int fc, c, Nsp;

Nsp = SkipWhite( fd );

fc = c = getc( fd );
if (fc == EOF) return fc;
*token++ = c;
if (c != '\n') {
    while ((c = getc( fd )) != EOF) {
	if (c != '\n' && !isspace(c)) *token++ = c;
	else break;
	}
    ungetc( (char)c, fd );
    }
*token++ = '\0';
*nsp     = Nsp;
return fc;
}

/* This routine skips white space but NOT newlines. Returns the number
   of spaces skiped. */
int SkipWhite( fd )
FILE *fd;
{
int c;
int nsp;
nsp = 0;
while ((c = getc( fd )) != EOF) {
    if (!isspace(c) || c == '\n') break;
    nsp++;
    }
ungetc( (char)c, fd );
return nsp;
}

/* This routine skips to the end of a line */
SkipLine( fd )
FILE *fd;
{
int c;

while ((c = getc( fd )) != EOF && c != '\n') ;
}

/* Read a line into a buffer.  Return the number of characters added */
int GetLine( fd, buf )
FILE *fd;
char *buf;
{
int c, cnt=0;;
while ((c = getc(fd)) != EOF && c != '\n') {*buf++ = (char)c; cnt++;}
*buf = '\0';
return cnt;
}

/* Copy s over itself, removing LEADING and TRAILING blanks.  Return the
   final number of charactes */
int TrimLine( s )
char *s;
{
char *s1 = s;
int  i;

while (*s1 && isspace(*s1)) s1++;
if (s1 != s) {
    for (i=0; s1[i]; i++) s[i] = s1[i];
    s[i] = '\0';
    }
i = strlen(s)-1;
while (i > 0 && isspace(s[i])) i--;
s[i+1] = '\0';
return i+1;
}

/* read chars until we find a leader (/*<character>) and a matching character.
   Then find the routine name (<name> - ) */
int FoundLeader( fd, routine, kind )
FILE *fd;
char *routine, *kind;
{
int c;

while ((c = getc( fd )) != EOF) {
    if (c == '/') {
        if (MatchLeader( fd, MATCH_CHARS, kind )) {
	    FindToken( fd, routine );
	    return 1;
	    }    
        }    
    }    
return 0;
}

/* Match a leader that starts with / * and then any of the selected
   characters.  Discards characters that don't match.  If we have
   entered this routine, we have already seen the first character (/) */
int MatchLeader( fd, Poss, kind )
FILE *fd;
char *Poss, *kind;
{ 
int c;
c = getc( fd );
if (c == '*') {
    /* In a comment.  We should really be prepared to skip this
       comment if we don't find that it is a documentation block */
    c = getc( fd );
    if (strchr( Poss, c )) {
        *kind = c;
        return 1;
        }
    }
return 0;
} 

/* 
  Copy an "include" to a buffer.  The form is / *I include-file-spec I* / 
  Only one per line.
 */
CopyIncludeName( fin, buffer )
FILE *fin;
char *buffer;
{
char *p;
int  c;

SkipWhite( fin );
p = buffer;

while ((c = getc(fin)) != EOF)  {
    if (c == '\n') break;
    if (c == 'I') {
	p[0] = 'I';
	c = getc(fin);
	if (c == '*') {
	    p[1] = '*';
	    c = getc(fin);
	    if (c == '/') { p--; break; }
	    p += 1;
	    }
	p += 1;
	}
    *p++ = c;
    }
while (p > buffer && *p == ' ') p--;
*++p = 0;
}

/* modifies the filename by converting it to the fullpath name and
   then removing the piece TOOLSDIR */
ExpandFileName(infilename,rlen)
char *infilename;
int  rlen;
{
  char tmp[MAX_FILE_SIZE],*name;
  name = tmp + rlen;
  SYGetFullPath(infilename,tmp,MAX_FILE_SIZE);
  if (rlen > 0) {
    strcpy(infilename,"$TOOLSDIR");
    strncat(infilename,name,MAX_FILE_SIZE-rlen-9);
  }
  else {
    strncpy(infilename,name,MAX_FILE_SIZE);
  }
    
return 0;
}

#include <sys/param.h>
extern char *getenv();
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif

/* returns the length of the full path name of the tools directory */
int GetToolsDirLength()
{
  char *toolsdir, truepath[MAXPATHLEN];
  int  rlen;

  toolsdir = getenv("TOOLSDIR");
  if (!toolsdir) return 0;
  else {
      SYGetRealpath(toolsdir,truepath);
      rlen = strlen(truepath);
      }
  return rlen;
}


/* Convert a string to upper case, in place */
UpperCase( s )
char *s;
{
char c;
while (*s) {
    c = *s;
    if (isascii(c) && islower(c)) *s = toupper(c);
    s++;
    }
}

#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
/* Get the date that a file was last changed */
LastChangeToFile( fname, date )
char *fname, *date;
{
struct stat buf;
struct tm   *tim;

if (stat( fname, &buf ) == 0) {
    tim = localtime( &(buf.st_mtime) );
    sprintf( date, "%d/%d/%d", 
	     tim->tm_mon+1, tim->tm_mday, tim->tm_year+1900 );
    }
else {
    date[0] = '\0';
    }
}

/*
   This is a comparision routine that is independent of case
   str2 should be upper case; str1 need not be.
   Returns 0 if they match, != 0 otherwise
 */
int MatchTokens( str1, str2 )
char *str1, *str2;
{
char buf[256];

strcpy( buf, str1 );
UpperCase( buf );
return strcmp( buf, str2 );
}
