#ifndef LINT
static char SCCSid[] = "@(#) ./comm/save/p4pg.c 07/23/93";
#endif

#include <stdio.h>
#include <time.h>
#if !defined(__MSDOS__)
#include <sys/param.h>
#endif
/* 
  From sys/param.h:
 x #define	MAXPATHLEN	1024
 x #define	MAXHOSTNAMELEN  64
 */
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

void PIFindHost();

/* @
    PIbuildP4PG - Build a P4-style procgroup file from a "standard"
    file of available machines.

    Input parameters:
.    np     - number of desired processors
.    fin    - file pointer to file with description
.    fout   - file pointer to output file
.    arch   - architecture of running program
.    pgm    - full name of program; possibly with %a for arch
.    mem    - amount of memory that the program may use
.    tim    - amount of time that the program may use

The format of the file is
$ hostname architecture owner hs:ms-he:me days memory time pagefaults nproc nice
$ (%s       %s          %s    %d %d %d %d %s   %d    %d   %d         %d     %d
$ Days are of the form daystart-dayend.  The value of days is
$   M - Monday
$   Tu- Tuesday
$   W - Wednesday
$   Th- Thursday
$   F - Friday
$   S - Saturday
$   Su- Sunday.
$ There may be no spaces in the specification.
@ */    
void PIbuildP4PG( np, fin, fout, arch, pgm, mem, tim, pfaults, dbg )
int    np;
FILE   *fin, *fout;
char   *arch, *pgm;
int    mem, tim, pfaults, dbg;
{
int    hs, ms, he, me, hh, mm, hostmem, hosttim, found, err, hostpf, hostnp;
char   hostarch[129], hostname[MAXHOSTNAMELEN], 
       hostowner[12], daystart, dayend;
char   htype[4];
char   pgmname[MAXPATHLEN], owner[12];
char   localhost[MAXHOSTNAMELEN];
char   *datestr, hostday[12];
int    dayofweek, hostdws, hostdwe;
int    niceval;
int    fnd_owner;
time_t timer;
struct tm *tm;

/* Add the "slave-less" master */
fprintf( fout, "local 0\n" );
np--;

/* Should initially skip to my local hostname, and continue from there */
gethostname( localhost, MAXHOSTNAMELEN );
PIFindHost( fin, localhost );

found     = 1;
fnd_owner = 0;
SYGetUserName( owner );

/* We'd also like to get the hostname so that the "local" node won't 
   be repeated */

/* Get the time */
timer = time( 0 );
tm = localtime( &timer );
hh    = tm->tm_hour;
mm    = tm->tm_min;
/* Use datestr to determine the day-of-the-week */
datestr = ctime( &timer );
dayofweek = PIConvertSysDay( datestr );

BuildPgmName( pgm, arch, pgmname );

while (np > 0) {
    /* Look for next line */
    err = fscanf( fin, "%s", hostname );
    if (err == 1 && hostname[0] == '#') {
	/* Skip to end of line */
	while (fgetc( fin ) != '\n') ;
	continue;
	}
    err = fscanf( fin, "%s %s %d:%d-%d:%d %s %d %d %d %d %d %s\n",
		  hostarch, hostowner,
                  &hs, &ms, &he, &me, hostday, 
                  &hostmem, &hosttim, &hostpf, &hostnp, &niceval, htype );
    if (err < 0) {
    	if (!found) return;
    	found     = 0;
	fnd_owner = 0;
    	rewind(fin);
    	continue;
        }
    /* Skip comments */
    if (hostname[0] == '#') continue;
    
    if (dbg) 
	fprintf( stdout, "%s %s %s %d:%d-%d:%d %s %d %d %d %d %d %s\n",
		  hostname, hostarch, hostowner,
                  hs, ms, he, me, hostday, 
                  hostmem, hosttim, hostpf, hostnp, niceval, htype );

    /* Start trying to match against needs */

    /* Arch first */
    if (arch) {
    	if (strcmp(arch,hostarch) != 0) {
	    if (dbg) fprintf( stdout, "Rejected for wrong arch\n" );
	    continue;
	    }
        }
    else {
    	/* See if the arch version is available */
        }

    /* If am the owner, I can use it */
    if (strcmp(hostowner, owner) == 0) {
	if (fnd_owner) {
	    if (dbg) 
		fprintf( stdout, "Rejected for duplicate of owner\n" );
	    continue;
	    }
	if (dbg) 
	    fprintf( stdout, "Accepted for %s == %s\n", owner, hostowner );
     	np = PIAddEntry( fout, hostname, pgmname, np, hostnp );
    	found++;
	fnd_owner = 1;
    	continue;
        }
    /* Otherwise, check resource requirements */
    /* Resource requirements */
    if (mem && hostmem && mem > hostmem) {
	if (dbg)
	    fprintf( stdout, "Rejected for exceeding memory\n" );
	continue;
	}
    if (tim && hosttim && tim > hosttim) {
	if (dbg) 
	    fprintf( stdout, "Rejected for exceeding cpu time\n" );
	continue;
	}
    if (pfaults && hostpf && pfaults > hostpf) {
	if (dbg) 
	    fprintf( stdout, "Rejected for exceeding page faults\n" );
	continue;
	}

    /* Time-of-day requirements.  This is a little tricky, since we want
       to allow specs like 18:00-08:00 */
    /* Check day first */
    if (timege(he,me,hs,ms)) {
	if (timege(hs,ms,hh,mm) || timege( hh,mm,he,me )) {
	    if (dbg) {
		fprintf( stdout, "Rejected for time of day: %d:%d not in ",
			 hh, mm );
		fprintf( stdout, "%d:%d-%d:%d\n", hs, ms, he, me );
		}
	    continue;
	    }
	}
    else {
    	if (timege(hh,mm,he,me) && timege( hs,ms,hh,mm)) {
	    if (dbg) {
		fprintf( stdout, "Rejected for time of day: %d:%d not in ",
			 hh, mm );
		fprintf( stdout, "%d:%d-%d:%d\n", hs, ms, he, me );
		}
	    continue;
	    }
        }
    /* Check the day of the week */
    hostdws = PIConvertSysDay( hostday );
    hostdwe = PIConvertSysDay( strchr( hostday, '-' ) + 1 );
    if (dayofweek < hostdws || dayofweek > hostdwe) {
	datestr[3] = '\0';
	if (dbg) 
	    fprintf( stdout, "Rejected for day of week: %s not in %s\n",
		     datestr, hostday );
	continue;
	}

    /* Add this host to the fout file */
    np = PIAddEntry( fout, hostname, pgmname, np, hostnp );
    found++;
    }
}

/* return 1 if the first time is greater than the second, 0 otherwise.
   Handle wrapping at midnight */
int timege(h1,m1,h2,m2)
int h1,m1,h2,m2;
{
if (h1 > h2) return 1;
if (h1 == h2 && m1 >= m2) return 1;
return 0;
}

BuildPgmName( pgm, arch, pgmname )
char *pgm, *arch, *pgmname;
{
char *p;
char temp[257];

strcpy( pgmname, pgm );
/* look for %a */
p = pgmname;
while (*p) {
    if (*p == '%' && p[1] == 'a') {
    	strcpy( temp, p+2 );
    	strcpy( p, arch );
    	strcat( p, temp );
        }
    else p++;
    }
}

/*
    Add lines to the procgroup file.  Return the number of processors to
    set
 */    
PIAddEntry( fout, hostname, pgmname, np, hostnp )
FILE *fout;
char *hostname, *pgmname;
int  np, hostnp;
{
int i;
if (hostnp > np) hostnp = np;

/* This needs to be modified for "backend" machines */
/* for (i=0; i<hostnp; i++)  */
    fprintf( fout, "%s %d %s\n", hostname, hostnp, pgmname );
return np - hostnp;
}

/* 
   Convert the day in system format (Mon, Tue, Wed, Thu, Fri Sat Sun)
   to the range 0 - 6
 */
PIConvertSysDay( d )
char *d;
{
if (d[0] == 'M') return 0;
if (d[0] == 'W') return 2;
if (d[0] == 'F') return 4;
if (d[0] == 'T') {
    if (d[1] == 'h') return 3;
    else             return 1;
    }
if (d[0] == 'S') {
    if (d[1] == 'u') return 6;
    else             return 5;
    }
return -1;
}

void PIFindHost( fin, localhost )
FILE *fin;
char *localhost;
{
int err;
char hostname[MAXHOSTNAMELEN];

while (1) {
    err = fscanf( fin, "%s", hostname );
    while (fgetc( fin ) != '\n') ;
    if (err == 1 && hostname[0] == '#') {
	continue;
	}
    if (err < 0) {
	/* We've exhausted the list */
	return;
	}

    if (strcmp( hostname, localhost ) == 0) {
	/* Found; now skip until we see a NEW host */
	while (1) {
	    err = fscanf( fin, "%s", hostname );
	    while (fgetc( fin ) != '\n') ;
	    if (err < 0) break;
	    if (strcmp( hostname, localhost ) != 0) break;
	    }
	return;
	}
    }
}

