/* 
   Communications activity is logged by default.  The number of sends and
   receives, and the amount of data, is all logged.  Turn this off by 
   defining LOGCOMMDISABLE

   This has gotten out-of-hand.  We want to define the following
   macros:
   LOGSENDSTART(len,type,to)
   LOGSENDEND(type);
   
   LOGRECVWAIT(type)             > for asynchronous ops
   LOGRECVREADY(type)           /
   LOGRECVSTART(type)              for synchronous ops
   LOGRECVEND(type,len,from)

   Each of these in turn contains 3 separate calls:
   traceing
   statecounting
   eventlogging

   Note that for receive, we may not have the len and from data easily
   available.  This is the rule:
   if eventlogging is enabled, we get the values and store them; 
   the RECVLEN etc routines just access these values rather than get the
   values from the implementation layer

   
   
 */

/* Used to control run-time logging */
#ifndef __LOGGING
#define __LOGGING
extern int cloglevel;

#if defined(LOGCOMMALL)
#define LOGCOMMTRACE
#define LOGCOMMCOUNTS
#define LOGCOMMEVENTS
#define LOGCOMMSUMMARY
#endif

/* Tracing generates output for each send/recv */
#if defined(LOGCOMMTRACE) && !defined(LOGCOMMDISABLE)
# ifndef NULL
# include <stdio.h>
# endif
extern FILE *_tracefile;
#define LPRINTS(a,type,len,to) {if(cloglevel&0x2){\
	   fprintf( _tracefile, "[%d] %s <Type %d(%d) To %d> [%s:%d]\n", \
		  MYPROCID, a, type, len, to, __FILE__, __LINE__ );\
		fflush(_tracefile);}}
#define LPRINTR(a,type) {if(cloglevel&0x2){\
           fprintf( _tracefile, "[%d] %s <Type %d> [%s:%d]\n", \
		  MYPROCID, a, type, __FILE__, __LINE__ );fflush(_tracefile);}}
extern char *_PIEventName();
#define LPRINTG(a,nam) {if(cloglevel&0x2){\
	 fprintf( _tracefile, "[%d] %s <%s> [%s:%d]\n", \
 	 MYPROCID, a, _PIEventName(nam), __FILE__, __LINE__ );\
	     fflush(_tracefile);}}
#else
#define LPRINTS(a,b,c,d)
#define LPRINTR(a,b)
#define LPRINTG(a,n)
#endif

/* Count the number of sends and receives, and the sizes */
#if defined(LOGCOMMCOUNTS) && !defined(LOGCOMMDISABLE)
extern int _logsend, _logsendn, _logrecv, _logrecvn;
#define LOGSENDCNT(n,type,to){_logsend++;_logsendn+=n;\
				  LPRINTS("send",type,n,to);}
#define LOGRECVCNT(n,type) {_logrecv++; _logrecvn+=n;LPRINTR("recv",type);}
#else
#define LOGSENDCNT(n,type,to) LPRINTS("send",type,n,to)
#define LOGRECVCNT(n,type)    LPRINTR("recv",type)
#endif

#include "system/state.h"
#if defined(LOGCOMMSUMMARY) && !defined(LOGCOMMDISABLE)
extern SYstate _state_send, _state_recv, _state_recvwait, 
               _state_gsync, _state_gop;
#define LOGSTATESTART(state,n) if(cloglevel&0x4)SYStatePush(state,n)
#define LOGSTATEEND(state,n)   if(cloglevel&0x4)SYStatePop(state,n)
#else
#define LOGSTATESTART(state,n)
#define LOGSTATEEND(state,n)
#endif

/* Event logging */
/* The choices of event numbers */
#define LOG_SENDS 103
#define LOG_SENDE 104
#define LOG_RECVS 105
#define LOG_RECVE 106
#define LOG_RECVWS 107
#define LOG_RECVWE 108
#define LOG_GSUMS 110
#define LOG_GSUME 111
#define LOG_GMAXS 112
#define LOG_GMAXE 113
#define LOG_GMINS 114
#define LOG_GMINE 115
#define LOG_GCOLS 116
#define LOG_GCOLE 117
#define LOG_GSCATS 118
#define LOG_GSCATE 119
#define LOG_GSYNCS 120
#define LOG_GSYNCE 121
#define LOG_GTOKS  122
#define LOG_GTOKE  123

#if defined(LOGCOMMEVENTS) && !defined(LOGCOMMDISABLE)
/* Routines to push and pop the event logging status (in ialog) */
extern void LOGpush(), LOGpop();

/* We are setup to use 2 different event logging systems; BLOG is a 
   simplified ALOG */
/* Use BLOG by default */
#ifdef USE_ALOG
#include "alog/alog.h"
#define LOGEVENT(a)    ALOG_LOG(MYPROCID,a,0,(char *)0)
#define LOGSENDSTARTEVENT(typ,n,to)   {LOGSTATESTART(&_state_send,n);\
			       ALOG_LOG(MYPROCID,LOG_SENDS,n,(char *)0);}
#define LOGRECVENDEVENT(typ,n,from) \
          ALOG_LOG(MYPROCID,LOG_RECVE,n,(char*)0); LOGSTATEEND(&_state_recv,n);
#define LOGOPSTART(n) {LPRINTG("Starting",n);LOGSTATESTART(&_state_gop,0);\
			   LOGEVENT(n);LOGpush();ALOG_DISABLE;}
#define LOGOPEND(n)   {LOGpop();LOGEVENT(n);LOGSTATEEND(&_state_gop,0);\
			   LPRINTG("Ending",n);}
#define LOGDEFINE(a,b) ALOG_DEFINE(a,b,"")
#define LOGDISABLE     ALOG_DISABLE
#define LOGENABLE      ALOG_ENABLE
#define LOGSTATUS      xx_alog_status
#define LOGSTATE(a,b,c,s) 
#else
#include "blog/blog.h"
#define LOGEVENT(a)    BLOG_LOG(a)
#define LOGSENDSTARTEVENT(typ,n,to) {\
		  LOGSTATESTART(&_state_send,n);BLOG_LOG4(LOG_SENDS,n,typ,to);}
#define LOGRECVENDEVENT(typ,n,from)  \
        BLOG_LOG4(LOG_RECVE,n,typ,from); LOGSTATEEND(&_state_recv,n);
#define LOGOPSTART(n) {LPRINTG("Starting",n);LOGSTATESTART(&_state_gop,0);\
			   LOGEVENT(n);LOGpush();BLOG_DISABLE;}
#define LOGOPEND(n)   {LOGpop();LOGEVENT(n);LOGSTATEEND(&_state_gop,0);\
			   LPRINTG("Ending",n);}
#define LOGDEFINE(a,b) BLOG_DEFINE(a,b)
#define LOGDISABLE     BLOG_DISABLE
#define LOGENABLE      BLOG_ENABLE
#define LOGSTATE(a,b,c,s) BLOG_DEFINE_STATE(a,b,c,s)
#define LOGSTATUS      xx_BLOG_status
#endif

#define LOGRECVRQ     {LOGSTATESTART(&_state_recvwait,0);LOGEVENT(LOG_RECVWS);}
#define LOGRECVSTARTEVENT(type)   {LPRINTR("recvstart",type);\
			  LOGSTATESTART(&_state_recv,0);LOGEVENT(LOG_RECVS);}
#define LOGSENDENDEVENT(type) LOGEVENT(LOG_SENDE); LOGSTATEEND(&_state_send,0);

#else
#define LOGEVENT(a)
#define LOGRECVRQ                 LOGSTATESTART(&_state_recvwait,0)
#define LOGRECVSTARTEVENT(type)   LOGSTATESTART(&_state_recv,0)
#define LOGRECVENDEVENT(typ,n,from) LOGSTATEEND(&_state_recv,n)
#define LOGSENDSTARTEVENT(typ,n,to) LOGSTATESTART(&_state_send,n)
#define LOGSENDENDEVENT(type)       LOGSTATEEND(&_state_send,0)
#define LOGOPSTART(n)      {LPRINTG("Starting",n);\
				LOGSTATESTART(&_state_gop,0);}
#define LOGOPEND(n)        {LOGSTATEEND(&_state_gop,0);LPRINTG("Ending",n);}
#define LOGDISABLE  
#define LOGENABLE   
#define LOGDEFINE(a,b)
#define LOGSTATE(a,b,c,s)
#endif

/* Here are the events that will be used to synchronize clocks */
#define EVENT_SYNC        -101
#define EVENT_PAIR_A1     -102
#define EVENT_PAIR_A2     -103
#define EVENT_PAIR_B1     -104

/*
   Now that we have defined all of the individual logging operations, 
   we define the ones to use in the communications operations
 */
#define LOGSENDSTART(len,type,to) {COMMCHECKSEND(type,len,to);\
		LOGSENDCNT(len,type,to);LOGSENDSTARTEVENT(type,len,to);}
#define LOGSENDEND(type) LOGSENDENDEVENT(type)

#define LOGRECVWAIT(type)   {LOGRECVRQ;LPRINTR("recvwait",type);}
#define LOGRECVREADY(type)  {LOGEVENT(LOG_RECVWE);\
                          LOGSTATEEND(&_state_recvwait,0);LOGRECVSTART(type);}
#define LOGRECVSTART(type) {LOGRECVSTARTEVENT(type);COMMCHECKRECV(type,0);}
#define LOGRECVEND(type,len,from)   {\
                LOGRECVENDEVENT(type,len,from);LOGRECVCNT(len,type);}

#endif /*__LOGGING*/
