/* 
   This file has a mapping from the new names to the old names 

   The core of the new names are all of the form

   PI[bnw][send|recv][ |rr][ |m]
  
   where
   b - blocking
   n - nonblocking (start)
   w - nonblocking (end) (that is, wait)

   rr - ready receiver ("force" type)

   m  - buffer allocated by system
 */

#define PIbsend    SENDSYNCNOMEM
#define PIbsendrr  SENDSYNCNOMEMFORCE
#define PIbsendm   SENDSYNC
#define PIbsendmrr SENDSYNCFORCE
#define PIbrecv    RECVSYNCNOMEM
#define PIbrecvrr  RECVSYNCNOMEMFORCE
#define PIbrecvm   RECVSYNC
#define PIbrecvmrr RECVSYNCFORCE

#define PInsend    SENDASYNCNOMEM
#define PInsendrr  SENDASYNCNOMEMFORCE
#define PInsendm   SENDASYNC
#define PInsendmrr SENDASYNCFORCE
#define PInrecv    RECVASYNCNOMEM
#define PInrecvrr  RECVASYNCNOMEMFORCE
#define PInrecvm   RECVASYNC
#define PInrecvmrr RECVASYNCFORCE

#define PIwsend    SENDWAITNOMEM
#define PIwsendrr  SENDWAITNOMEMFORCE
#define PIwsendm   SENDWAIT
#define PIwsendmrr SENDWAITFORCE
#define PIwrecv    RECVWAITNOMEM
#define PIwrecvrr  RECVWAITNOMEMFORCE
#define PIwrecvm   RECVWAIT
#define PIwrecvmrr RECVWAITFORCE

#define PInstatus  ASYNCDONE
#define PInprobe   ASYNCPROBE
#define PIbprobe   SYNCPROBE

#define PIbrecvUnsz RECVSYNCUNSZ
#define PIbrecvProbed RECVPROBED

/* New message buffer routines */
#define PINewSendBuf   MSGALLOCSEND
#define PINewRecvBuf   MSGALLOCRECV
#define PIFreeSendBuf  MSGFREESEND
#define PIFreeRecvBuf  MSGFREERECV

/* Switch to "task" from "process" */
#define PImytid     MYPROCID
#define PInumtids   NUMNODES

/* Message topology */
#define PIdistance  MSGDISTANCE
#define PIdiameter  MSGDIAMETER
#define PIMsgSizes  MSGSIZES
#define PITagRange  MSGTYPERANGE

/* Current "last" message stuff; switch to thread-safe version soon */
#define PIfrom      RECVFROM
#define PItype      RECVTYPE
#define PIsize      RECVLEN

/*
   The global routines are simply PIname
 */
#define PIAllProcs    ALLPROCS
#define PSAllProcs    ALLPROCS
#define PIgcsum       GCSUM
#define PIgdsum       GDSUM
#define PIgisum       GISUM
#define PIgfsum       GFSUM
#define PIgcmax       GCMAX
#define PIgdmax       GDMAX
#define PIgimax       GIMAX
#define PIgfmax       GFMAX
#define PIgcmin       GCMIN
#define PIgdmin       GDMIN
#define PIgimin       GIMIN
#define PIgfmin       GFMIN
#define PIgcor        GCOR
#define PIgior        GIOR
#define PIgcand       GCAND
#define PIgiand       GIAND
#define PIgsync       GSYNC
#define PIgcol        GCOL
#define PIgcolx       GCOLX
#define PIbcast       GSCATTER
#define PIgtoken      GTOKEN
#define PIbcastSrc    GSCATTERSRC

#define PIcrecv       RECVCANCEL
#define PIcsend       SENDCANCEL

/* Processor set operations */
#define PSmytid       PSMYPROCID
#define PSnumtids     PSNUMNODES

/* Type defs for the nonblocking id's */
typedef ASYNCSendId_t PISendId_t;
typedef ASYNCRecvId_t PIRecvId_t;
#ifdef NO_ASYNC_SEND 
#define PI_NO_NSEND
#endif
#ifdef NO_ASYNC_RECV
#define PI_NO_NRECV
#endif
#ifdef NO_NATIVE_GLOBAL
#define PI_NO_NATIVE_GLOBAL
#endif
#ifdef NO_FORCE
#define PI_NO_READYRECEIVE
#endif
/* 
   We will eventually add the generic combine/reduce versions
 */
