#ifndef lint
static char SCCSidI[] = "@(#) ./comm/initcm5.c 07/23/93";
#endif

/* This file is INCLUDED by comm/init.c */

int __CM5LEN, __CM5FROM, __CM5TYPE;
int __MYPROCID, __NUMNODES;

/*
    cm5exitall - terminate all processes in an execution (parallel exit)
    See init.c for a complete description of the interface.
 */
static void cm5exitall(msg,rc)
char *msg;
int  rc;
{
if (msg) 
    CMMD_error( "%s\n", msg );
else 
    CMMD_error( "Exiting...\n" );
/* Just in case ... */
exit(rc);
}

#if CMMDVersion < 2 
/* The actual routine to run on the node MUST be named 
    CMPE_routinename 
   The below code won't work, since the host-style interface for the cm-5
   is not this convenient.
   The HOST code needs to be:
   
   CMMD_enable();
   worker();
   CMMD_disable();

   Also, most system calls are not supported on the CM5 (it isn't really
   running a full OS, not even as much as intelnx!).
   
   The interface routine is called CMPE_foo. (or CMFPE_foo from Fortran).
   Further, the host, node, and interface code must be compiled separately.
   This is a royal mess.  Onward:

   The host program needs to do:
   <set the actual node program>
   CMMD_enable();
   PIiWorker();
   <pass the arguments to the workers>
   <wait for program to finish on all workers>
   CMMD_disable();
   
   The interface program is
   void PIiWorker();

   The node program is then
   PIiWorker()
   <get the arguments>
   <run the user's routine>
   <let the host know that we're done>

   It MAY NOT BE POSSIBLE to set the user's (node) routine in the host.
   This would be unfortunate.  It may be necessary to use some fancy work
   to declare a user routine that can be used (generating the "host"
   program automatically from the user's node program).  This may 
   be the best approach.

   As a refinement, the node programs could ask the host to perform
   services for them, such as printf (which the cm-5 does WRONG).
   These basic services would be 
       <stdio>
       environment inquiry (getwd, getenv, getusername, ...)
       

 */
int PIcall( )
{
/* Broken */
}

#else 

#define PI_HAS_PIINIT
void PIinit()
{
__NUMNODES = CMMD_partition_size();
__MYPROCID = CMMD_self_address();
PISetupCollectiveTree( );
}

#include <cm/cmmd-io.h>
int PIcall( np, procgroup, pfname, routine, argc, argv )
int  np, argc;
char **procgroup, *pfname;
char **argv;
int  (*routine)();
{
int rc;

SYSetExitAll(cm5exitall);
PIinit();

CMMD_fset_io_mode( stdout, CMMD_independent );
CMMD_fset_io_mode( stderr, CMMD_independent );

#if !defined(LOGCOMMDISABLE)
PIGetDebugArgs( &argc, argv );
#endif

PIinitlog();
rc = (*routine)( argc, argv );
PIendlog();
return rc;
}
#endif

#define PI_HAS_INIT
#define PI_HAS_EXIT
