#include <stdio.h>
#include "comm/examples/angst/angst.h"

/*
    This is a simple program to stress the communications performance of
    a parallel machine.  The program tcomm does a more exhaustive
    test of the individual links
 */
    
int EachToAll(), AllToAll();

static long Patterns[12] = {
    0xffffffff, 0xaaaaaaaa, 0x88888888, 0x80808080, 0x80008000, 0x80000000,
    0x00000000, 0x55555555, 0x77777777, 0x7f7f7f7f, 0x7fff7fff, 0x7fffffff };

typedef enum { Blocking, NonBlocking } Protocol;

int worker();

/* Stub for general parallel call */
main(argc,argv)
int argc;
char *argv[];
{
PICall( worker, argc, argv );
}


int worker(argc,argv)
int argc;
char *argv[];
{
int c;
int (* f)();
long reps,len,size,error_flag, pattern;
long first,last,incr, svals[3];
Protocol protocol  = Blocking;

SYusc_init();

if (SYArgHasName( &argc, argv, 1, "-help" )) {
  if (PImytid != 0) return 0;
  fprintf( stderr, "%s - stress test communication\n", argv[0] );
  fprintf( stderr, 
"[-sync | -async | -force] [-size start end stride]\n\
[-reps n]\n\
Stress communication links by various methods.  The tests are \n\
combinations of\n\
  Protocol: \n\
  -sync        Blocking sends/receives    (default)\n\
  -async       NonBlocking sends/receives\n\
  -force       Ready-receiver (with a null message)\n\
\n" );
  fprintf( stderr, 
"  Message sizes:\n\
  -size start end stride                  (default 0 1024 32)\n\
               Messages of length (start + i*stride) for i=0,1,... until\n\
               the length is greater than end.\n\
\n\
  Number of tests\n\
  -reps n      Number of times message is sent (default 1000)\n\
\n" );

  return 0;
  }

if (PInumtids < 2) {
    fprintf( stderr, "Must run stress with at least 2 nodes\n" );
    return 1;
    }
reps          = DEFAULT_REPS;
error_flag    = 0;
f             = EachToAll;
svals[0]      = 32;
svals[1]      = 1024;
svals[2]      = 32;

if (SYArgHasName( &argc, argv, 1, "-async" ))     protocol  = NonBlocking;
if (SYArgHasName( &argc, argv, 1, "-sync"  ))     protocol  = Blocking;
SYArgGetIntVec( &argc, argv, 1, "-size", 3, svals );
SYArgGetInt(    &argc, argv, 1, "-reps", &reps );

f = EachToAll;
switch( protocol ) {
/*     case NonBlocking:   f = round_trip_async; break; */
    case Blocking:      f = EachToAll;  break;
    }
first = svals[0];
last  = svals[1];
incr  = svals[2];

for (pattern=0; pattern<13; pattern++) {
    for (size=first; size<last; size+=incr) {
        if (PImytid == 0)
            fprintf( stdout, "Running size = %d longs with pattern %x\n", 
                     size, (pattern < 12) ? Patterns[pattern] : pattern );
        (*f)( pattern, size );
        }
    }
}

int EachToAll( pattern, size )
int pattern;
int size;
{
int sender, dest, tag, from, err=0, bufmsize, actsize, bufsize;
char *buffer;

buffer = (char *)MALLOC( size * sizeof(long) );  CHKPTRN(buffer);
bufsize = size * sizeof(long);
for (sender=0; sender < PInumtids; sender++) {
    tag = sender;
    if (PImytid == sender) {
	for (dest=0; dest < PInumtids; dest++) {
	    if (sender != dest) {
		SetBuffer( buffer, size, pattern );
		PIbsend( tag, buffer, bufsize, dest, MSG_INT );
		}
	    }
	}
    else {
	bufmsize = bufsize;
	PIbrecv( tag, buffer, bufmsize, MSG_INT );
	if ((from = PIfrom()) != sender) {
	    fprintf( stderr, "Message from %d should be from %d\n", from, 
		     sender );
	    err++;
	    }
	if ((actsize = PIsize()) != bufsize) {
	    fprintf( stderr, "Message from %d is wrong size (%d != %d)\n", 
		     sender, actsize, bufsize );
	    err++;
	    }
	if (CheckBuffer( buffer, actsize / sizeof(long), pattern )) {
	    fprintf( stderr, "Message from %d is corrupt\n", sender );
	    err++;
	    }
	}
    }
FREE( buffer );
return err;
}

int AllToAll( pattern, size )
int pattern;
int size;
{
int sender, dest, tag, from, err=0, bufmsize, actsize, bufsize;
char *buffer;

buffer  = (char *)MALLOC( size * sizeof(long) );  CHKPTRN(buffer);
bufsize = size * sizeof(long);
tag     = PImytid;
for (dest=0; dest < PInumtids; dest++) {
    if (PImytid != dest) {
	SetBuffer( buffer, size, pattern );
	PIbsend( tag, buffer, bufsize, dest, MSG_INT );
	}
    }
for (sender=0; sender<PInumtids; sender++) {
    tag = sender;
    if (PImytid != sender) {
	bufmsize = bufsize;
	PIbrecv( tag, buffer, bufmsize, MSG_INT );
	if ((from = PIfrom()) != sender) {
	    fprintf( stderr, "Message from %d should be from %d\n", from, 
		     sender );
	    err++;
	    }
	if ((actsize = PIsize()) != bufsize) {
	    fprintf( stderr, "Message from %d is wrong size (%d != %d)\n", 
		     sender, actsize, bufsize );
	    err++;
	    }
	if (CheckBuffer( buffer, actsize / sizeof(long), pattern )) {
	    fprintf( stderr, "Message from %d is corrupt\n", sender );
	    err++;
	    }
	}
    }
FREE( buffer );
return err;
}


SetBuffer( buf, size, pattern )
long *buf;
int  size, pattern;
{
long val;
int  i;

if (pattern < 12) {
    val = Patterns[pattern];
    for (i=0; i<size; i++) 
	buf[i] = val;
    }
else {
    for (i=0; i<size; i++) {
	buf[i] = Patterns[pattern % 12];
	}
    }
}

int CheckBuffer( buf, size, pattern )
long *buf;
int  size, pattern;
{
long val;
int  i;

if (pattern < 12) {
    val = Patterns[pattern];
    for (i=0; i<size; i++) 
	if (buf[i] != val) return 1;
    }
else {
    for (i=0; i<size; i++) {
	if (buf[i] != Patterns[pattern % 12]) return 1;
	}
    }
return 0;
}

