#ifndef lint
static char SCCSid[] = "@(#) ./comm/dist.c 07/23/93";
#endif

#include "tools.h"
#include "comm/comm.h"

/* These provide for important parts of the information on the topology */
/* BUG - THESE need to come from the "nbrs.c" code */
static int _PINX = 1, _PINY = 1;
/* A default is the HC topology.  Various systems may reset this */
static int (*_PIGetNbrs)() = PIGetNbrsHC;

/*
    This file contains routines to determine the distance between two
    processor, depending on the topology of the parallel machine.  So
    far, we have:

    gdisthc  - hypercube
    gdistms2 - 2d mesh
    gdistdf  - default
 */
int gdistdf( from, to )
int from, to;
{
return from != to;
}

/* The following is a service routine for the hypercube distance routines */
static int popmask[16] = { 0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4 };
int popcount( a )
unsigned char a;
{
return popmask[ a & 0xf ] + popmask[ (a >> 4) & 0xf ];
}

gdisthc( from, to )
int from, to;
{
unsigned int diff = from ^ to;
return popmask[ diff & 0xf ] + popmask[ (diff >> 4) & 0xf ] + 
       popmask[ (diff >> 8) & 0xf ];
}

/*
    In order to do the 2-d mesh distance, we need the size of the mesh
 */
gdistms2( from, to )
int from, to;
{
int nx, ny;
int ifr, jf, it, jt;
int diff, dist;

/* compute the indices of the from and to locations */
nx  = _PINX;
ny  = _PINY;
ifr = from % nx;
jf  = from / nx;
it  = to % nx;
jt  = to / nx;

dist = (it > ifr) ? (it - ifr) : (ifr - it);
dist += (jt > jf) ? (jt - jf ) : (jf - jt);
return dist;
}

#if defined(intelnx) && (defined(inteldelta) || defined(intelparagon))
int gdiamdelta()
{
int nx, ny;
mypart( &nx, &ny );
/* This should probably be (nx + ny - 2) */
return ((nx > ny) ? nx : ny) - 1;
}
#endif


