/*
    These are the definitions particular to the p4 implementation.
 */

#ifndef __commn3
#define __commn3

#ifndef __commh
#include "comm/comm.h"
#endif

extern int __N3FROM, __N3LEN, __N3TYPE, __N3GLOBALTYPE, __N3DUMMY;

#define NO_ASYNC_SEND
#define NO_ASYNC_RECV
#define NO_FORCE

/* I don't really want to do this because SYNCPROBE is a busy loop */
#if defined(LOGCOMMEVENTS) && defined(COMM_OK_BUSY_LOOPS)
#define LOGRECVQ(type) LOGRECVWAIT(type);SYNCPROBE(type);LOGRECVREADY(type);
#else
#define LOGRECVQ(type) 
#endif

#define SENDSYNC(type,buffer,length,to,datatype) \
        {LOGSENDSTART(length,type,to);\
	     nwrite((char*)(buffer),length,to,type,0);\
         LOGSENDEND(type);}
#define RECVSYNC(type,buffer,length,datatype) {\
        __N3FROM = -1; /* From Any */ __N3TYPE = type;\
        LOGRECVQ(type);	LOGRECVSTART(type); \
       __N3LEN = nread((char*)(buffer),&__N3TYPE,length,&__N3FROM,&__N3DUMMY);\
        LOGRECVEND(type,__N3LEN,__N3FROM);}
#define SENDSYNCNOMEM(type,buffer,length,to,datatype) \
        SENDSYNC(type,buffer,length,to,datatype)
/* Note: if the buffer was smaller than the received message, we should
   generate an error */
#define RECVSYNCNOMEM(type,buffer,length,datatype)  \
        RECVSYNC(type,buffer,length,datatype); 

#define RECVSYNCUNSZ(type,bufp,size,datatype) printf("not implemented\n");

#define SYNCPROBE(type) {\
	__N3TYPE = type; __N3FROM= -1;\
	while(ntest(&__N3TYPE,&__N3FROM) < 0);}
#define ASYNCPROBE(type) (__N3TYPE=type,__N3FROM= -1,\
        (ntest(&__N3TYPE,&__N3FROM) >= 0)

/* This is just RECVSYNC, but without resetting __N3FROM */
#define RECVPROBED(type,buffer,length,datatype) printf("not implemented\n");

#define RECVLEN()  __N3LEN
#define RECVFROM() __N3FROM
#define RECVTYPE() __N3TYPE

/* Most of these are provided through an add-on library.  I'll deal with this
   later */
#ifdef N_HAS_GLOBAL
#define GISUM(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(int),p4_int_sum_op);else\
                                   gisumset(val,n,work,procset);
#define GDSUM(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(double),p4_dbl_sum_op);else\
                                   gdsumset(val,n,work,procset);
#define GFSUM(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(float),p4_flt_sum_op);else\
                                   gfsumset(val,n,work,procset);
#define GIMAX(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(int),p4_int_max_op);else\
				   gihighset(val,n,work,procset);
#define GIMIN(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(int),p4_int_min_op);else\
                                   gilowset(val,n,work,procset);
#define GDMAX(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(double),p4_dbl_max_op);else\
				   gdhighset(val,n,work,procset);
#define GDMIN(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(double),p4_dbl_min_op);else\
                                   gdlowset(val,n,work,procset);
#define GIOR(val,n,work,procset)   \
    giorset( val, n, work, procset )
#define GSYNC(procset)             gsyncset(procset)
#define GCOL(lbuf,lsize,gbuf,gsiz,glen,procset,datatype) \
        gcolset(lbuf,lsize,gbuf,gsiz,glen,procset,datatype)
#define GCOLX(lbuf,gsizes,gbuf,procset,datatype) \
        gcolxset(lbuf,gsizes,gbuf,procset,datatype)
#define GTOKEN(procset,i) gtokenset(procset,i)
#define GSCATTER(buf,siz,issrc,procset,datatype) {LOGOPSTART(LOG_SCATS);\
        gscatterset(buf,siz,issrc,procset,datatype);LOGOPEND(LOG_SCATE);}
#define GSCATTERSRC(buf,siz,src,procset,datatype) {LOGOPSTART(LOG_GSCATS);\
         gscattersetsrc(buf,siz,src,procset,datatype);LOGOPEND(LOG_GSCATE);}
#else
#define NO_NATIVE_GLOBAL
#endif

#define MSGALLOCSEND(msg,maxmsg,type)  msg = (type *)MALLOC(maxmsg)
#define MSGFREESEND(msg)               FREE(msg)
#define MSGALLOCRECV(msg,maxmsg,type)  msg = (type *)MALLOC(maxmsg)
#define MSGFREERECV(msg)               FREE(msg)

#define NUMNODES nnodes()
#define MYPROCID npid()
/* The max value below is approximate */
#define MSGTYPERANGE(low,high) {*(low)=0;*(high)=0x3fff;}
#define MSGDISTANCE(from,to)   gdistdf(from,to)
#define MSGSIZES(min,max)      {*min=0;*max=(16384*8096);}

/* Need to replace this with a call to whoami...*/
#define MSGDIAMETER            (NUMNODES-1)
#endif
