/*

                              DISCLAIMER
                              ==========

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   

    If the software is modified by someone else and passed on, we, the authors
    want its recipients to know that what they have is not the original, so
    that any problems introduced by others will not reflect on the original
    authors' reputations.
*/                                            

/*
** Test program for transforms module.
** W.T. Hewitt.
*/

#include "nurbh.h"


#define LINE printf("*************************************\n")

PR_nurb c1, c2, c3, c4;
PR_nurb s1, s2, s3, s4;
Pvector3 v1;

Pint ee;

Pmatrix3 xx;

main()
{
  printf("Testing NURBS\n");

  nrb_clear(&c1);
  nrb_clear(&c2);
  nrb_clear(&c3);
  nrb_clear(&c4);

  nrb_clear(&s1);
  nrb_clear(&s2);
  nrb_clear(&s3);
  nrb_clear(&s4);

  nrb_circle(&c1);

  v1 =ptk_vector3(100.0,100.0,100.0);
  ptk_scale3(&v1,PREPLACE,xx);
  nrb_xform(&c1,xx);

  LINE;
  printf("Unit Cylinder\n");

  nrb_extrude(&c1,ptk_point3(0.0,0.0,100.0),&s1,&ee);
  nrb_dump(stdout,&s1);

  nrb_copy(&c1,&c2);	/*copy a curve*/
  v1 =ptk_vector3(2.0,2.0,2.0);
  ptk_scale3(&v1 ,PREPLACE,xx);
  v1 = ptk_vector3(100.0,200.0,300.0);
  ptk_shift3(&v1,PPOSTCONCATENATE,xx);
  nrb_xform(&c2,xx);
  nrb_ruled(&c1,&c2,&s2,&ee);
  LINE;
  printf("Ruled Surface\n");
  nrb_dump(stdout,&s2);

  LINE;
  printf("Sphere\n");
  nrb_sphere(&s3);
  v1 = ptk_vector3(100.0,100.0,100.0);
  ptk_scale3(&v1,PREPLACE,xx);
  nrb_xform(&s3,xx);
  nrb_dump(stdout,&s3);

  LINE;
  printf("Torus\n");
  nrb_torus(&s4);
  ptk_scale3(&v1,PREPLACE,xx);
  nrb_xform(&s4,xx);
  nrb_dump(stdout,&s4);

  nrb_stats(stdout);
  nrb_dumplists(stdout);

  printf("End of NURBs test.\n");
  return 0;
}

/* End. */
