// vector.hpp

// A vector definition	 for real or complex vector 
// adds Linear Algebra operations to BasicArray


// rcsid: $Id$  @(#)vector.hpp	1.8 15:17:30 9/30/92  EFC

#ifndef _VECTOR_H
#define _VECTOR_H 1.8

#include <math.h>

#include <barray.hpp>

class Vector : public BasicArray
{
	public:
	  const int& rows;
	  Vector() : BasicArray(1), rows(sze) {}
	  Vector(const int r) : BasicArray(r), rows(sze) {}
	  Vector(const Vector&);
	  ~Vector() {}
	Vector& operator=(const Vector& v);

	Vector& operator+=(const Vector&);
	Vector& operator-=(const Vector&);

	friend Vector operator+(const Vector&, const Vector&);	    // Vector+Vector
	friend Vector operator-(const Vector&, const Vector&);	    // Vector-Vector
	friend scalar_type operator*(const Vector&,const Vector&);  // Vector*Vector

	 // Vector*scalar
	friend Vector operator*(const Vector& v, const double d);
#ifdef COMPLEX
	friend Vector operator*(const Vector& v, const Complex d);
#endif
	// scalar*Vector
	friend Vector operator*(const scalar_type d,const Vector& v)
			{ return v * d; }

	// scalar assignment
	scalar_type operator=(const scalar_type d);

	friend int operator==(const Vector&,const Vector&);	// equality


};

#endif


