// Vector.cpp		a vector class implementation


static const char rcsid[] = "@(#)vector.c++	1.8 11:32:51 10/2/92   EFC";

#include <error.hpp>
#include <vector.hpp>

// #define DEBUG

Vector::Vector(const Vector& b) : BasicArray(b.size()),rows(sze) 
{

	(BasicArray& )*this = (BasicArray& )b;
}

Vector& Vector::operator=(const Vector &b)
{
	if ( size() != b.size())
	{
		Error error("Vector =");
		error << "a = b different sizes, a = " << size()
		      << ", b = " << b.size();
		 error.fatal();
	}

	(BasicArray& )*this = (BasicArray &)b;

	return *this;

}

scalar_type Vector::operator=(const scalar_type d)
{
#ifdef DEBUG
	cerr << "Vector scalar assignment called\n";
#endif
	int sz = size(); 
	for (int i = 0; i < sz; i++)
		( *this )[i] = d;

	return d;	
}

Vector& Vector::operator+=(const Vector &a)		// v += a
{
	if ( a.size() != size())
	{
		Error error("Vector += ");
		error << "vector a += vector b different sizes, a = " << size()
		      << ", b = " << a.size();
		error.fatal();
	}
	int sz = size();
	for (int i = 0; i < sz; i++)
		( *this )[i] += a[i];

	return *this;
}

Vector& Vector::operator-=(const Vector &a)		// v -= a
{
	if ( a.size() != size())
	{
		Error error("Vector -= ");
		error << "vector a -= vector b different sizes, a = " << size()
		      << ", b = " << a.size();
		error.fatal();
	}

	int sz = size(); 
	for (int i = 0; i < sz; i++)
		( *this )[i] -= a[i];

	return *this;
}

Vector operator+(const Vector& a, const Vector &b)		//  v = a + b
{
	if ( a.size() != b.size())
	{
		Error error("Vector +");
		error << "vector a + vector b different sizes, a = " << a.size()
		      << ", b = " << b.size();
		error.fatal();

	}

	int sz = a.size();
	Vector sum(sz);

	for (int i = 0; i < sz; i++)
		sum[i] = a[i] + b[i];

	return sum;

}

Vector operator-(const Vector& a, const Vector &b)		//  v = a - b
{

	if ( a.size() != b.size())
	{
		Error error("Vector -");
		error << "vector a - vector b different sizes, a = " << a.size()
		      << ", b = " << b.size();
		error.fatal();
	}

	int sz = a.size();
	Vector diff(sz);

	for (int i = 0; i < sz; i++)
		diff[i] = a[i] - b[i];

	return diff;

}

// vector dot product
scalar_type operator*(const Vector &a,const Vector &b)		//  v = a * b
{
	if ( a.size() != b.size() )
	{
		Error error("Vector *");
		error << "vector a * vector b incommensurate, a = " << a.size()
			<< ", b = " << b.size();
		error.fatal();
	}

	int i, sz = a.size();
	scalar_type prod, zero = 0.0;

	for (i = 0, prod = zero; i < sz; i++)
			prod += a[i] * b[i];

	return prod;

}

Vector  operator*(const Vector& v, const double d)		// v = a * d
{
#ifdef DEBUG
	cerr << "scalar*vector\t ";
#endif
	int i, sz = v.size();
	Vector b = v;

#ifdef DEBUG
	cerr << "vector*scalar, for dimension: " << v.size() << endl;
#endif

	for (i = 0; i < sz; i++)
			b[i] *= d;

	return b;

}

#ifdef COMPLEX
Vector  operator*(Vector& v, const Complex d)		// v = a * c
{
#ifdef DEBUG
	cerr << "scalar*vector\t ";
#endif
	int i, sz = v.size();
	Vector b = v;

#ifdef DEBUG
	cerr << "vector*scalar, for dimension: " << size() << endl;
#endif

	for (i = 0; i < sz; i++)
			b[i] *= d;

	return b;

}
#endif

int operator==(const Vector &a,const Vector &b)	//	int i = (a == b)
{
	if ( a.size() != b.size() )
	{
		Error error("Vector ==");
		error << "vector a and vector b different sizes, a = " << a.size()
			<< ", b = " << b.size();
		error.fatal();
	}

	int i, sz = a.size();
	int l = 1;

	for (i = 1; i < sz; i++)
			l = l && ( a[i] == b[i] );

	return l;

}
