// vdynamics.hpp		definition of a virtual class for dynamical systems
//				where each grid point is a vector quantity

// rscid: $Id$ @(#)vdynamics.hpp	1.2 13:26:42 7/2/93 EFC

#ifndef VDYNAMICS_HPP_
#define VDYNAMICS_HPP_ 1.2


#include <vector.hpp>

class VectorDynamics
{
	protected:
	   int n;		// number of grid points
	   int m;		// components at each grid point
	   Vector *u;
	   float dx, dt, t, r;
	   char *name;		// name of the method
	   int namelen;
	   VectorDynamics(int n_in, int m_in,float dxin, float dtin,
						  		char *nam = NULL);
	  virtual ~VectorDynamics() { if (namelen > 0) delete []name; delete[]u; }
	public:
	  const char* method() { return name; }
	  virtual void step(const int) = 0;
	  VectorDynamics& operator++() { step(1); return *this; }

	  // get data into and out of model	
	  friend Vector* operator<<(Vector*,const VectorDynamics&);	
	  friend VectorDynamics& operator<<(VectorDynamics&,Vector*);
	  friend Vector* operator>>(const VectorDynamics&, Vector *);
	  friend VectorDynamics& operator>>(Vector *, VectorDynamics&);

	  // output model data directly
	  friend ostream& operator<<(ostream& os, const VectorDynamics&);

	// manipulators
	friend VectorDynamics& restart(VectorDynamics& s);

	typedef VectorDynamics&(*VDynManip)(VectorDynamics&);

	// applicator for the zero parameter manipulators
	friend VectorDynamics& operator<<(VectorDynamics& sb, VDynManip f)
							 { f(sb); return sb; }

};

#endif

