// standio.hpp		A pair of classes to handle I/O from EITHER a
//			named file OR STDIN/STDOUT
//	tested on MSDOS with Zortech C++ 3.0		Borland C++ 3.0
//	       on Unix  with AT&T 2.1 on MIPS and SGI Indigo workstations
// rcsid: @(#)standio.hpp	1.5 11:46:04 7/2/93   EFC

#ifndef STANDARD_IO_HPP_
#define STANDARD_IO_HPP_ 1.5

#include <iostream.h>

#ifdef __ZTC__
#include <fstream.hpp>
#ifndef LOCAL_FILEBUF		/* Zortech MUST have this define ON */
#define LOCAL_FILEBUF
#endif
#else
#include <fstream.h>
#endif


class Stdin : public ifstream
{
	private:
          char *fname;
#ifdef LOCAL_FILEBUF
	  filebuf InputFile;
#endif
	  int do_open_input(char* infile);
          void open_input(int *argc, char **argv);                             
        public:
          Stdin(int *argc, char **argv);
          Stdin(char* infile = NULL);
         ~Stdin() { if (fname) close(); }
	  const char* name() const { if (fname) return fname;
          			     else	return "stdin"; }
                                     
};

class Stdout : public ofstream
{
	private:
          char *fname;
#ifdef LOCAL_FILEBUF
	  filebuf OutputFile;
#endif
	  int  do_open_output(char* outfile);
	  void open_output(int *argc, char **argv);                             
        public:
          Stdout(int *argc, char **argv);
          Stdout(char* outfile = NULL);
         ~Stdout() { flush(); if ( fname ) close(); }
	  const char* name() const { if (fname) return fname;
          			     else	return "stdout"; }
};

#endif

