// laxwen.hpp		1-D Lax Wendroff (two step) method

//		u_t + f_x = rhs
//				where rhs is optional, assumed zero otherwise

// looks OK, except not sure about implementation of RHS term

#ifndef LAX_WENDROFF_HPP_
#define LAX_WENDROFF_HPP_ 1.1

#include <vdynamics.hpp>

#ifndef SPACE_DERIV
#define SPACE_DERIV
typedef float (*SpaceDeriv)(Vector*,int,int);
#endif

class LaxWendroff : public VectorDynamics
{
	private:
	  Vector *u_half;
	  SpaceDeriv f;
	  SpaceDeriv rhs;
	public:
	  LaxWendroff(SpaceDeriv f, float dx_in, float dt_in, int n_in, int m_in,
		      SpaceDeriv user_rhs = NULL);
	 ~LaxWendroff() { delete []u_half; }
	  void step(const int steps = 1);
};

#endif
