// laxwen.cpp		implementation of 1-D (two-step) Lax-Wendroff

static const char rscid[] = "@(#)laxwen.c++	1.1 13:26:18 7/2/93   EFC";

#include <laxwen.hpp>

float null_rhs(Vector*, int, int)
{
	return 0;
}

LaxWendroff::LaxWendroff(SpaceDeriv fin, float dxin, float dtin, int ni, int mi,
			 SpaceDeriv user_rhs) :
			 	f(fin),
			 VectorDynamics(ni,mi,dxin,dtin,"Two-Step Lax-Wendroff")
{

	u_half = new Vector[m];

	for (int i = 0; i < m; i++)
		u_half[i].resize( n );

	if ( user_rhs == NULL )
		rhs = null_rhs;
	else
		rhs = user_rhs;

}

void LaxWendroff::step(const int steps)
{
	int it, i, j, jm, jp;

	for (it = 0; it < steps; it++)
	{
		// first half step
		for (i = 0; i < m; i++)
		{
			for (j = 0; j < n; j++)
			{
				jp = j + 1;
				if ( jp >= n )
					jp -= n;
				u_half[i][j] = 0.5 * (u[i][jp] + u[i][j])
						-0.5 * r * (f(u,i,jp) - f(u,i,j))
						+ dt * 0.5 * (rhs(u,i,jp)
							+ rhs(u,i,j) );
	
			}
		}

		// second half step
		for (i = 0; i < m; i++)
		{
			for (j = 0; j < n; j++)
			{
				jm = j - 1;
				if ( jm < 0 )
					jm += n;
				u[i][j] -= r * (f(u_half,i,j) - f(u_half,i,jm))
						+ dt * rhs(u,i,j);
			}
		}



	}
	
}


