/* invm.c	invm		*/

/* routines for linear systems processing via LU factorization
	from C Tools for Scientist and Engineers, L. Baker, 1989

	modified to generate its own workspace */

static const char rcsid[] = "@(#)invm.c++	1.3 00:59:18 7/2/93   EFC";

#include <stdio.h>

#ifdef __TURBOC__
#include <alloc.h>
#endif
#ifdef __ZTC__
#include <stdlib.h>
#endif

// #define DEBUG

#include <lumatrix.hpp>
#include <error.hpp>

#ifdef PROFILE
#include <profile.hpp>
#endif

/* invm		invert a matrix given the LU factorization of that matrix */

Matrix invm(const LUMatrix &a)
{
#ifdef PROFILE
	Profile pr( "imvm()" );
#endif
	double t;
	int i, j, k, l, kb, kp1, nm1, n, coln;
	Error error("invm");

	if ( a.rows != a.cols )
	{
      error << "matrix inverse, not square: " << a.rows << " by " << a.cols << endl;
	  error.fatal();
	}

	n = coln = a.rows;

	Matrix inverse(n,n);
	inverse = a;

	// Matrix inverse(a); 		  // this SHOULD work with any compiler
					  // but evidently not Zortech 2.1

	nm1 = n - 1;

	/* inverse U */
	for (k = 0; k < n; k++)
	{
		inverse[k][k] = t = 1.0 / inverse[k][k];
		t = -t;
		// sscal(k, t, &(inverse[0][k]), coln);
		for (i = 0; i < k; i++)
			inverse[i][k] *= t;
		kp1 = k + 1;
		if (nm1 >= kp1)
		{
			for (j = kp1; j < n; j++)
			{
				t = inverse[k][j];
				inverse[k][j] = 0.0;
				// saxpy(k+1,t,&(inverse.m[0][k]),coln,&(inverse.m[0][j]),coln);
				for (i = 0; i < kp1; i++)
					inverse[i][j] += t * inverse[i][k];

			}
		}
	}

	/* INV(U) * INV(L)	*/
	if (nm1 >= 1)
	{
		double *work = new double[n];
		error.memory( work );


		for (kb = 0; kb < nm1; kb++)
		{
			k = nm1 - kb - 1;
			kp1 = k + 1;
			for (i = kp1; i < n; i++)
			{
				work[i] = inverse[i][k];
				inverse[i][k] = 0.0;
			}
			for (j = kp1; j < n; j++)
			{
				t = work[j];
				// saxpy(n,t,&(inverse.m[0][j]),coln,&(inverse.m[0][k]),coln);
				for (i = 0; i < n; i++)
					inverse[i][k] += t * inverse[i][j];
			}
			l = a.pivot[k];
			if (l != k)
				// sswap(n,&(inverse.m[0][k]),coln,&(inverse.m[0][l]),coln);
				for (i = 0; i < n; i++)
				{
					t = inverse[i][k];
					inverse[i][k] = inverse[i][l];
					inverse[i][l] = t;
				}
		}
		
		delete work;
	}

	return inverse;

}









