// error.hpp		Definition of an error reporting class

// rcsid: %W% %U% %G%   EFC

#ifndef _ERROR_REP_HPP_
#define _ERROR_REP_HPP_		%I%

#include <stdlib.h>
#include <iostream.h>

#ifdef __ZTC__
#include <sstream.hpp>
#ifndef LOCAL_STRBUF
#define LOCAL_STRBUF
#endif
#else
#include <strstream.h>
#endif

class Error : public ostrstream
{
	private:
	   ostream& my_os;
	   char *prog;
	   int len;
#ifdef LOCAL_STRBUF
	 strstreambuf buffr;
#endif
	   void report(const char *msg = NULL);
	public:
          Error(ostream& user_os = cerr) :  
#ifdef LOCAL_STRBUF
					ios(&buffr),
#endif
				my_os(user_os), prog(NULL), len(0) {}          
	  Error(const char *s,ostream& user_os = cerr);
	  ~Error() { if (len != 0) delete []prog; }

	  virtual int sync() { report(); return my_os.rdbuf()->sync(); }

	  void warning(const char *msg = NULL);
	  void nonfatal(const char *msg = NULL) { warning(msg); }
	  void fatal(const char * = NULL );
	  void memory(const void * = NULL );


	  // maninpulator version of fatal and warning
          friend Error& fatal(Error& er)    { er.fatal();   return er; }
          friend Error& warning(Error& er)  { er.warning(); return er; } 

	  typedef Error& (*ErrManip)(Error&);


	// applicators for the zero parameter manipulators
       friend Error& operator<<(Error& err, ErrManip f) { (*f)( err ); return err; }

};

// a nonmember functions, mostly so I remember how to do a manipulator
ostream& terminate(ostream& os);

#endif

