// barray2D.hpp		A Basic 2D floating point or complex array class
//			just a simple array


// rcsid: $Id$ @(#)barray2d.hpp	1.2 09:55:27 2/3/93   EFC

#ifndef _BASIC_2DARRAY_HPP_
#define _BASIC_2DARRAY_HPP_  1.2

#ifdef __ZTC__
#include <fstream.hpp>
#else
#include <fstream.h>
#endif

#include <scalar.hpp>


class Basic2DArray
{
    private:
	void init(const int r = 1, const int c = 1);
    protected:
	int by_columns;
	int rz, cz;
	scalar_type **m;
	virtual scalar_type& elem(const int,const int);		// checked access
	virtual scalar_type  elem(const int,const int) const;
    public:
	const int& rows;
	const int& cols;
	Basic2DArray()  : rows(rz), cols(cz), by_columns(0) { init(); }
    	Basic2DArray(const int r, const int c) : rows(rz), cols(cz), by_columns(0)
						 { init(r,c); }
        Basic2DArray(const Basic2DArray& f2);

        Basic2DArray& operator = (const Basic2DArray& f2);// assignment from 2DArray

	virtual ~Basic2DArray();

	virtual void resize(const int nr, const int nc);  // destructive resizing

 	// scalar assignment
        virtual void reset(const scalar_type val = 0.0);
	scalar_type operator=(const scalar_type val) { reset(val); return val; }

	virtual scalar_type* operator[](const int i) { return m[i]; }
	virtual scalar_type* operator[](const int i) const { return m[i]; }

	scalar_type& operator()(const int i,const int j)       { return elem(i,j); }
	scalar_type  operator()(const int i,const int j) const { return elem(i,j); }


	void io_by_rows()    { by_columns = 0; }     // row at a time ASCII I/O
	void io_by_columns() { by_columns = 1; }     // column at a time ASCII I/O

	int read(ifstream &ifs);  		// binary read, always by row
	int write(ofstream &ofs); 		// binary write, always by row

	friend istream& operator>>(istream& is, Basic2DArray& ary);
	friend ostream& operator<<(ostream& os, const Basic2DArray& ary);
};



#endif




