// barray.hpp		A Basic floating point or complex array class
//			just a simple array
// rcsid: $Id$ @(#)barray.hpp	1.9 23:49:33 7/1/93   EFC

#ifndef _BASIC_ARRAY_HPP_
#define _BASIC_ARRAY_HPP_  1.9

#ifdef __ZTC__
#include <fstream.hpp>
#else
#include <fstream.h>
#endif

#include <scalar.hpp>


class BasicArray
{
    private:
	int rsize;				// the actual size of the array
	int wdth;
    protected:
	int sze;				// the known size of the array
	scalar_type *x;
    public:
	const int& n;
	BasicArray()  : n(sze), sze(0), wdth(1),rsize(1)
				 { x = new scalar_type[1]; }
    	BasicArray(const int ni) : n(sze), sze(ni), wdth(1), rsize(ni)
				 { x = new scalar_type[n]; }
        BasicArray(const BasicArray& f2);
        virtual ~BasicArray() { delete []x; }
        BasicArray& operator = (const BasicArray& f2);// assignment from BasicArray

	virtual int size() const { return sze; }
	virtual void resize(const int nsize);

	
	void freeze() { resize( n ); } // fix the actual size to the current size
	void trim(const int nsize);    // make array seem smaller than it is
	void untrim()		{ sze = rsize; }

 	// scalar assignment
        virtual void reset(const scalar_type val = 0.0);
	scalar_type operator=(const scalar_type val) { reset(val); return val; }

	virtual scalar_type& operator[](const int i) { return x[i]; }
	scalar_type  operator[](const int i) const   { return x[i]; }

  	// binary read and write
	virtual int read(ifstream &ifs, int count = -1, int first = 0);
	virtual int write(ofstream &ofs, int count = -1, int first = 0);

	// set output columns
	void width(const int w) { wdth = w; }
	friend istream& operator>>(istream& is, BasicArray& ary);
	friend ostream& operator<<(ostream& os, const BasicArray& ary);
};



#endif




