// barray.cpp	Implementation of bare Float,Double or Complex Array class

#include <barray.hpp>

static const char rcsid[] = "@(#)barray.c++	1.9 23:50:03 7/1/93   EFC";

// #define DEBUG

#ifdef DEBUG
#include <debug.hpp>
#include <traceback.hpp>

extern Debug debug;

#endif

#ifdef __TURBOC__
#include <signal.h>
#include <float.h>

static void handler(int sig)
{
#ifdef DEBUG
	if ( debug )
	cerr << "error handler, signal = " << sig << '\n';
#endif

	// clear the error
	_fpreset();
	
	signal(SIGFPE, handler);
	
}

#endif

BasicArray::BasicArray(const BasicArray& f2) : n(sze)
{
#ifdef DEBUG
	TraceBack tb( "BasicArray copy constructor");
#endif
	rsize = sze = f2.size();
	wdth = f2.wdth;
	
	x = new scalar_type[rsize];

	for (int k = 0; k < rsize; k++)
		x[k] = f2.x[k];

}


BasicArray& BasicArray::operator = (const BasicArray& f2)
{
	if ( this == &f2 )
		return *this;

	if ( x != NULL )
		delete []x;

	rsize = sze = f2.size();
	// wdth = f2.wdth;

	x = new scalar_type[rsize];

	for (int k = 0; k < rsize; k++)
		x[k] = f2.x[k];

	return *this;	
}

void BasicArray::trim(const int nsize)	// make the array SEEM to be smaller
{
#ifdef DEBUG
	if ( debug )
	{
	cerr << "BasicArray::trim( " << nsize << " ), trimming from " << sze;
	cerr << " , rsize = " << rsize << '\n';
	}
#endif
	if ( nsize >= 0 && nsize <= rsize )
		sze = nsize;
}

void BasicArray::reset(const scalar_type val)
{
#ifdef DEBUG
	TraceBack tb( "BasicArray reset (scalar assignment)" );
#endif
	for (int k = 0; k <sze; k++)
        		x[k] = val;
}

void BasicArray::resize(const int nsize)
{
	 int k, kend;

	sze = nsize;

	if ( nsize == rsize )
		return;			// nothing to do

	 kend = rsize;

	  if ( nsize < kend )			// keep the smaller size
			kend = nsize;

	  scalar_type *xn = new scalar_type[ nsize ];

	  // copy the old data
	  for (k = 0; k < kend; k++)
			xn[k] = x[k];

	  delete []x;

	  rsize = nsize;
	  x = xn;

}

int BasicArray::write(ofstream &ofs, int count, int first)
{
	if ( count < 0 )
		count = sze - first;

	if ( count <= 0 )
		return -1;

	ofs.write( (char *)&(x[first]), count * sizeof( scalar_type ) );

	if ( ofs.fail() )
		return -1;
	else
		return 0;
 
}

int BasicArray::read(ifstream &ifs, int count, int first)
{

	if ( count < 0 )
		count = sze;

	if ( (first + count) > sze )
		resize( first+count );

 
	ifs.read( (char *)&(x[first]), count * sizeof( scalar_type ) );


	if ( ifs.fail() )
		return -1;
	else
		return 0;

}

istream& operator>> (istream& is, BasicArray& arry)
{
	scalar_type new_x;
	int k, kend;

#ifdef __TURBOC__
	static int first = 1;

	
	if ( first )
	{
		signal( SIGFPE, handler );
		first = 0;
	}
#endif

	if ( is.eof() )
		return is;


	kend = arry.size();

	for (k = 0; k < kend; k++)
	{		
		is >> new_x;
		

 		// end of file reached, abort the read
		if ( is.eof() || is.fail() )
			return is;

		arry[k] = new_x;		
	}
	
	return is;
	
}

ostream& operator<< (ostream& os,const BasicArray& arry)
{
	int iend = arry.size();

	for (int i = 0; i < iend;  )
	{
		os << arry[i];
		if ( (++i % arry.wdth) == 0 )
				os << '\n';
		else
				os << "   "; 
	}

//	if ( (i % arry.wdth) != 0 )	os << '\n';
	
	return os;
	
}








