/*--------------------------------------------------------------------------
 Signal-reversal operator.
--------------------------------------------------------------------------*/
#include <stdio.h>
#include <math.h>

#include "sig.h"
#include "arith.h"

static char sccsid[] = "@(#)reverse.c	1.1 7/15/91";

void
reverse_x_int16(n, pin, pout)
    int n;
    short *pin, *pout;
{
    int i;
    for (i=0; i<n/2; i++) {
	short tmp;
	tmp = pin[i];
	pin[i] = pout[n-i-1];
	pout[n-i-1] = tmp;
    }
}

void
reverse_x_float32(n, pin, pout)
    int n;
    float *pin, *pout;
{
    int i;
    for (i=0; i<n/2; i++) {
	float tmp;
	tmp = pin[i];
	pin[i] = pout[n-i-1];
	pout[n-i-1] = tmp;
    }
}

/*--------------------------------------------------------------------------
 Run signal thru reverse_array.
--------------------------------------------------------------------------*/
void
sig_reverse(this)
    sig_t *this;
{
    int nrec = this->nrec;
    int reclen = this->reclen;
    int offset;
    int n;

    switch (this->kind) {
    case hdr_CINT16:
    case hdr_CBFP16:
	for (offset=n=0; n<nrec; n++, offset += reclen)
	    reverse_x_int16(reclen, this->im+offset, this->im+offset);
	/* fall thru */
    case hdr_INT16:
    case hdr_BFP16:
	for (offset=n=0; n<nrec; n++, offset += reclen)
	    reverse_x_int16(reclen, this->re+offset, this->re+offset);
	break;

    case hdr_CFLOAT32:
	for (offset=n=0; n<nrec; n++, offset += reclen)
	    reverse_x_float32(reclen, ((float *)this->im)+offset, 
				    ((float *)this->im)+offset);
	/* fall thru */
    case hdr_FLOAT32:
	for (offset=n=0; n<nrec; n++, offset += reclen)
	    reverse_x_float32(reclen, ((float *)this->re)+offset,
				    ((float *)this->re)+offset);
	break;
    default:
	badkind("sig_reverse", this->kind);
    }
}
