#ifndef macro_h
#define macro_h

/* @(#)macro.h	1.1 7/16/91 */

/* How macros are stored */
typedef struct {
    char *name;
    char **lines;
    int nlines;
} macro_t;

#define macro_MAXARGS 50

/* How the state of a macro instantiation is described */
typedef struct {
    int mac;		/* index of macro being expanded */
    int linenum;	/* next line of macro to expand */
    int argc;		/* # of arguments macro was invoked with */
    char *argv[macro_MAXARGS];	/* arguments macro was invoked with */
} macro_inst_t;

#if defined(__STDC__) || defined(__cplusplus)
# define _ARGS_(s) s
#else
# define _ARGS_(s) ()
#endif

/* macro.c */
void macro_define _ARGS_((char *name));
void macro_append _ARGS_((char *s));
macro_inst_t *macro_expand_begin _ARGS_((char *s, char *args));
void macro_expand_end _ARGS_((macro_inst_t *inst));
int macro_expand_next _ARGS_((macro_inst_t *inst, char *buf));

#undef _ARGS_
#endif
