/*--------------------------------------------------------------------------
 Bit-reversal operator.
--------------------------------------------------------------------------*/
#include <stdio.h>
#include <math.h>
#include <malloc.h>

#include "sig.h"

static char sccsid[] = "@(#)bitrev.c	1.1 7/15/91";

/*--------------------------------------------------------------------------
 Stupid bitreversal routine.  Works for n <= 8192.
--------------------------------------------------------------------------*/
int
bitrev(i, n)
    register int i;
    register int n;
{
    n >>= 1;
    return
	((i & 1<<0) ? (n>>0) : 0) +
	((i & 1<<1) ? (n>>1) : 0) +
	((i & 1<<2) ? (n>>2) : 0) +
	((i & 1<<3) ? (n>>3) : 0) +
	((i & 1<<4) ? (n>>4) : 0) +
	((i & 1<<5) ? (n>>5) : 0) +
	((i & 1<<6) ? (n>>6) : 0) +
	((i & 1<<7) ? (n>>7) : 0) +
	((i & 1<<8) ? (n>>8) : 0) +
	((i & 1<<9) ? (n>>9) : 0) +
	((i & 1<<10) ? (n>>10) : 0) +
	((i & 1<<11) ? (n>>11) : 0) +
	((i & 1<<12) ? (n>>12) : 0) +
	((i & 1<<13) ? (n>>13) : 0);
}


static int bitrev_tabsize = -1;
static int *bitrev_tab = NULL;
/*--------------------------------------------------------------------------
 Fill static lookup table with bit reversal indices for array of size n.
--------------------------------------------------------------------------*/
void
bitrev_setup(n)
    int n;
{
    int i;

    if (n == bitrev_tabsize) return;
    if (bitrev_tab != NULL) free(bitrev_tab);
    bitrev_tab = (int *)malloc(n * sizeof(int));
    bitrev_tabsize = n;

    for (i=0; i<n; i++)
	bitrev_tab[i] = bitrev(i,n);
}

void
bitrev_int16(n, pin, pout)
    int n;
    short *pin, *pout;
{
    int i;
    int *tab;

    bitrev_setup(n);
    tab = bitrev_tab;
    for (i=0; i<n; i++)
	pout[*tab++] = *pin++;
}

void
bitrev_float32(n, pin, pout)
    int n;
    float *pin, *pout;
{
    int i;
    int *tab;

    bitrev_setup(n);
    tab = bitrev_tab;
    for (i=0; i<n; i++)
	pout[*tab++] = *pin++;
}


/*--------------------------------------------------------------------------
 Run signal thru bitrev_array, return result.
--------------------------------------------------------------------------*/
sig_t *
sig_bitrev(this)
    sig_t *this;
{
    sig_t *sig;
    int nrec = this->nrec;
    int reclen = this->reclen;
    int offset, n;

    sig = sig_new(nrec, reclen, this->kind, this->fname);

    switch (this->kind) {
    case hdr_CINT16:
    case hdr_CBFP16:
	for (offset=n=0; n<nrec; n++, offset += reclen)
	    bitrev_int16(reclen, this->im+offset, sig->im+offset);
	/* FALL THRU */
    case hdr_INT16:
    case hdr_BFP16:
	for (offset=n=0; n<nrec; n++, offset += reclen)
	    bitrev_int16(reclen, this->re+offset, sig->re+offset);
	break;

    case hdr_CFLOAT32:
	for (offset=n=0; n<nrec; n++, offset += reclen)
	    bitrev_float32(reclen, ((float *)this->im)+offset, 
				((float *)sig->im)+offset);
	/* FALL THRU */
    case hdr_FLOAT32:
	for (offset=n=0; n<nrec; n++, offset += reclen)
	    bitrev_float32(reclen, ((float *)this->re)+offset,
				((float *)sig->re)+offset);
	break;
    default:
	badkind("sig_bitrev", this->kind);
    }

    if (this->kind & hdr_KIND_BFP) {
	/* Copy exponants. */
	memcpy((char *)sig->exp, (char *)this->exp, nrec * sizeof(short));
    }

    return sig;
}
