#ifndef bfp_h
#define bfp_h
/* @(#)bfp.h	1.2 7/18/91 */

#include "imath.h"

/* Following globals control use of block floating point. */
int bfp_do;		/* set to 1 to enable, 0 to disable. */
int bfp_scale_ct;	/* set to 0 before string of bfp operations */

/* Block floating point support.  Scan thru array; if any value has
 * absolute value greater than 1<<FRAC_BITS, divide whole array by two and
 * increment the scale count.
 * To disable, set bfp_do to 0.
 * Really, this restricts us to FRAC_BITS bits of fraction, but that's life.
 * I wonder how people really do this?
 */
#define BFP_SCALE(n,xr,xi,j) \
    if (bfp_do) {						\
	for (j= (n); --j>=0; ) {				\
	   int t;						\
	   t = xr[j]; if (t < 0) t=-t; if (t > (1<<FRAC_BITS)) break;	\
	   t = xi[j]; if (t < 0) t=-t; if (t > (1<<FRAC_BITS)) break;	\
	}							\
	if (j >= 0) {						\
	    /* Yep, need to scale data. */			\
	    bfp_scale_ct++;					\
	    for (j= (n); --j>=0;) {				\
		xr[j] /= 2;					\
		xi[j] /= 2;					\
	    }							\
	}							\
    }								\

#if defined(__STDC__) || defined(__cplusplus)
# define _ARGS_(s) s
#else
# define _ARGS_(s) ()
#endif

/* bfp.c */
void bfp_normalize_result _ARGS_((int len, short *xr, short *xi));
void sig_bfp_normalize _ARGS_((sig_t *this, int bits));

#undef _ARGS_
#endif
