// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/


#ifndef _TimeSchedulerdefs_h
#define _TimeSchedulerdefs_h 1

#ifdef __GNUG__
#  pragma interface
#endif

#include <Thread.h>

class TimeScheduler {
    Thread *pThread;
    double pTime;
public:
    TimeScheduler();
    TimeScheduler(Thread *p);
    TimeScheduler(Thread *p, double when);

    operator==(TimeScheduler &p);
    operator<=(TimeScheduler &p);

    Thread *thread();
    double time();
    bool isThread();

    //
    // the following is used for subclasses of TimeScheduler
    //
    //    virtual void doit();
};


inline Thread*
TimeScheduler::thread()
{
    return(pThread);
}

inline bool
TimeScheduler::isThread()
{
    return(pThread != NULL);
}

inline double
TimeScheduler::time()
{
    return(pTime);
}

inline TimeScheduler::TimeScheduler()
{
    pThread = 0;
    pTime = 0;
}

inline TimeScheduler::TimeScheduler(Thread *p)
{
    pThread = p;
    pTime = 0;
}

inline TimeScheduler::TimeScheduler(Thread *p, double w)
{
    pThread = p;
    pTime = w;
}

inline int TimeScheduler::operator==(TimeScheduler &p)
{
    return( (pTime == p.pTime)
	   && (pThread -> priority() == (p.thread() -> priority())));
}

inline int TimeScheduler::operator<=(TimeScheduler &p)
{
    return(
	   (pTime <  p.pTime)
	   || ( (pTime == p.pTime)
	       && (pThread -> priority() <= (p.thread() -> priority()))) );
}

// equality operator
#ifndef TimeSchedulerEQ
#define TimeSchedulerEQ(a, b)  ((a) == (b))
#endif

// less-than-or-equal
#ifndef TimeSchedulerLE
#define TimeSchedulerLE(a, b)  ((a) <= (b))
#endif

// comparison : less-than -> < 0; equal -> 0; greater-than -> > 0
#ifndef TimeSchedulerCMP
#define TimeSchedulerCMP(a, b) ( ((a) <= (b))? (((a) == (b))? 0 : -1) : 1 )
#endif

// hash function
#ifndef TimeSchedulerHASH
extern unsigned int hash(TimeScheduler&);
#define TimeSchedulerHASH(x)  hash(x)
#endif

// initial capacity for structures requiring one

#ifndef DEFAULT_INITIAL_CAPACITY
#define DEFAULT_INITIAL_CAPACITY 100
#endif


#endif
