// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//

#ifdef __GNUG__
#  pragma implementation
#endif

#include "SingleCpuMux.h"
#include "CpuMuxP.h"
#include "SpinLock.h"
#include "Thread.h"
#include "ThreadContainer.h"
#include "ReserveByException.h"
#include <math.h>

//
//	This can not be private, or we wont see all the action
//
extern int CpuMuxDebugFlag;

SingleCpuMux::SingleCpuMux(bool debug) : CpuMux(debug)
{
    CpuMuxDebugFlag = debug;
    pNameTemplate = "SingleCpuMux";
    iYam = 0;
    sprintf(nameSpace, "[%s-%d] ", pNameTemplate, iYam);
    pName = nameSpace;
}

SingleCpuMux::~SingleCpuMux()
{
    delete myCurrentEvents;
    myCurrentEvents = 0;
}

void
SingleCpuMux::fireItUp(int, unsigned)
{
    warmThePot(1);
    stirItAround();
    coolItDown();
}

void
SingleCpuMux::warmThePot(int)
{
    pid = getpid();
    enabled = 1;
}

void
SingleCpuMux::coolItDown()
{
    // empty
}

void
SingleCpuMux::add_(Thread *who)
{
    myCurrentEvents -> add( who );
}

//
// This is the job dispatcher.
//

void
SingleCpuMux::stirItAround()
{
    currentThread = 0;

    while( ! *terminated ) {
	currentThread = myCurrentEvents -> remove();
	if (currentThread == 0 ) {
	    return;
	}

	CERR_PRE;
	cerr << name() << " switch to ";
	cerr << currentThread->name() << "\n";
	CERR_POST;

	systemTransfer( currentThread );
	raisedBy -> handleException();
	raisedBy = 0;
    }
}

ThreadContainer*
SingleCpuMux::allocateThreadContainer()
{
    assert(0);
    abort();
}
