#include <assert.h>
#include <SpinLock.h>
#include "SEv.SplayPQ.h"

#ifdef NEW_DELETE_WORKS
//
// Provide constructors/destructors 
//

static SpinLock freeLock;
static const int AllocateChunk = 1000;
static SEvSplayNode *freeList = 0;

void *
SEvSplayNode::operator new(long size)
{
    freeLock.reserve();
    
    if ( freeList == 0 ) {
	SEvSplayNode *p
	    = (SEvSplayNode *) new char[ sizeof(SEvSplayNode) * AllocateChunk ];
	for (int i = 0; i < AllocateChunk; i++ ) {
	    p[i].lt = &(p[i+1]);
	}
	p[ AllocateChunk - 1].lt = 0;
	freeList = &(p[ 0 ]);
    }
    SEvSplayNode *t = freeList;
    freeList = freeList -> lt;
    t -> lt = 0;
    freeLock.release();
    return(t);
}

void
SEvSplayNode::operator delete(void *p)
{
    //
    // why would anyone ever pass NULL to the delete? -- BECAUSE IT'S A BUG
    //
    assert( p != 0 );
    freeLock.reserve();
    SEvSplayNode *pp = (SEvSplayNode *)p;
    pp -> lt = freeList;
    freeList = pp;
    freeLock.release();
}

#endif
