#ifdef __GNUG__
#  pragma implementation
#endif

#include "Pareto.h"
#include <math.h>

ParetoParameter::ParetoParameter()
{
    n = 0;

    sum_ln_xi = 0;
}

void
ParetoParameter::sample(double xi)
{
    n++;
    sum_ln_xi += log(xi);
}

void
ParetoParameter::operator+=(double xi)
{
    sample(xi);
}

double ParetoParameter::parameter()
{
    double a = n / sum_ln_xi;
    return(a);
}

//
// We store the pareto parameter as its inverse, as this eliminates
// a division in operator()
//

Pareto::Pareto(double a, RNG *gen)
: Random(gen)
{
    parameter_a = 1.0 / a;
}

Pareto::Pareto(ParetoParameter& a, RNG *gen)
: Random(gen)
{
    parameter_a = 1.0 / a.parameter();
}

void
Pareto::parameter(double a)
{
    parameter_a = 1.0 / a;
}

void
Pareto::parameter(ParetoParameter& a)
{
    parameter_a = 1.0 / a.parameter();
}

double
Pareto::parameter()
{
    return( 1.0 / parameter_a );
}

double
Pareto::operator()()
{
    double  u = pGenerator -> asDouble(); 
    double up = pow(u, parameter_a);
    return( 1.0 / up );
}

