//-*-c++-*-
#ifndef _Fifo_h_
#define _Fifo_h_
//
// This may look like C code, but it is really -*- C++ -*-
//
//	Copyright (C) 1988,1989,1990,1991,1992
//	Dirk Grunwald (grunwald@cs.colorado.edu)
//	
//	Awesime is distributed in the hope that it will be useful, but
//	WITHOUT ANY WARRANTY.  No author or distributor accepts
//	responsibility to anyone for the consequences of using it or
//	for whether it serves any particular purpose or works at all,
//	unless he says so in writing.  
//	
//	Everyone is granted permission to copy, modify and
//	redistribute Awesime, but only under the conditions described
//	in the Awesime General Public License.  A copy of this license
//	is supposed to have been given to you along with Awesime so
//	you can know your rights and responsibilities.  It should be
//	in a file named COPYING.  Among other things, the copyright
//	notice and this notice must be preserved on all copies.
//	

#ifdef __GNUG__
#  pragma interface
#endif

templace <class Item, class Index >
class Fifo {
    
    Item *list;
    Index AllocatedSize;
    Index listHead;
    Index listTail;
    
    char *pValid;
    unsigned int listElements;
    
    Index advance(Index i) {
	return( ((i+1) >= allocatedSize) ? (0) : (i+1) );
    };
    
public:
    
    Fifo(int defaultLength = 0);
    virtual ~Fifo();
    
    virtual void resize(int howMany);
    //
    // Operations on the list
    //
    virtual void add(Item *t);
    virtual bool remove(Item *item);
    virtual bool removeIfFound(Item* item);
    
    Item& item(Index i){ return(list[i]); };
    
    Index  maxIndex(){return(allocatedSize);};
    
    virtual bool isEmpty();
    virtual unsigned int size();
    
    virtual void classPrintOn(ostream& s);
};

#endif
