#ifndef _EventSequence_h_
#define _EventSequence_h_

#ifdef __GNUG__
#  pragma interface
#endif

#include "ReserveByException.h"
#include "SpinFetchAndOp.h"

class SEvSplayPQ;

class EventSequence : public ReserveByException {

protected:
    SpinLock lock;
    SEvSplayPQ *pile;
    int counter;
    SpinFetchAndOp tickets;

private:
    virtual int reserveByException( Thread *byWho, ExceptionReserve& );
    
public :

    EventSequence( int count = 1 );
    virtual ~EventSequence();

    //
    // Advance the counter by X, freeing everyone who was waiting
    // for something before the new value of X.
    //
    virtual void advance(int X = 1);

    //
    // Get a ticket that you can wait for
    //
    int ticket();

    //
    // Await a specific event value
    //
    virtual void await(int);
    int count();

    //
    // Reset the EventSequence to some value. This will release
    //
    virtual void reset(int = 1);
};

inline int 
EventSequence::ticket()
{
    return( tickets += 1 );
}

inline int 
EventSequence::count()
{
    lock.reserve();
    int i = counter;
    lock.release();
    return( i );
}

#endif
