#include <stream.h>
#include "LPseq.h"
#include "LPmux.h"
#include <assert.h>


void
LPseq::deliver( int channel, LPmsg& what )
{

    assert( channel >= 0 && channel < numberOfOutputs );

    LP *who = out[ channel ].lp;
    what.who(who);

    //
    // can I execute it directly? -- this should always be safe
    //
    if ( what.simulatedTime() <= simulatedTime() ) {
	TheLPmux -> directCall();
	who -> action( what );
    } else {
	TheLPmux -> add( what );
    }
}

void
LPseq::deliverSelf( LPmsg& what )
{

    LP *who = this;
    what.who(who);

    //
    // can I execute it directly? -- this should always be safe
    //
    if ( what.simulatedTime() <= simulatedTime() ) {
	TheLPmux -> directCall();
	who -> action( what );
    } else {
	TheLPmux -> add( what );
    }
}


//
// Deliver an item, and it's the last thing to happen in this time slice
//
void
LPseq::deliverLast( int channel, LPmsg& what )
{
    assert( channel >= 0 && channel < numberOfOutputs );

    LP *who = out[ channel ].lp;
    what.who(who);

    //
    // can I execute it directly?
    //
    if ( what.simulatedTime() <= simulatedTime() ) {
	TheLPmux -> directCall();
	who -> action( what );
    } else {
	if ( TheLPmux -> directCallOk() ) {
	    TheLPmux -> directCall();
	    who -> action( what );
	}
	else {
	    TheLPmux -> add( what );
	}
    }
}

void
LPseq::action( LPmsg& what )
{
    assert( 0 );
}
