#include <stream.h>
#include "LPmux.h"
#include "LPmsg.SplayPQ.h"
#include "LP.h"

LPmux *TheLPmux;

LPmux::LPmux()
{
    CurrentSimulatedTime = 0;
    pDirectCalls = 0;
    TheLPmux = this;
}

LPmux::~LPmux()
{
    // do nothing
}

void
LPmux::fireItUp()
{
    while (! events.empty() ) {
	LPmsg& event = events.front();

	assert( event.simulatedTime() >= CurrentSimulatedTime );

	CurrentSimulatedTime = event.simulatedTime();

	pDirectCalls = 0;
	event.who() -> action( event );

#if 0
	if ( pDirectCalls > 0 ) {
	    cerr << "Did " << pDirectCalls << " direct calls\n";
	}
#endif

	events.del_front();
    }

}
