#ifndef _LPseq_h_
#define _LPseq_h_

#include "LP.h"
#include "LPmux.h"

class LPseq : public LP {

    friend class LPmux;

public:

    LPseq( char *name = "" );

    static ClassId classId();
    virtual bool isA(ClassId);

    TimeUnit simulatedTime();
    //
    // deliver a message to another LP
    //
    virtual void deliver( LP *who, LPmsg* what );
    virtual void deliverSelf(LPmsg* what );
    virtual void deliverLast( LP *who, LPmsg* what );

    virtual void divert(LPmsg *what, TimeUnit when);

    void busyFor( TimeUnit until );
    void busyUntil( TimeUnit until );

    virtual void action( LPmsg* what);
};

static inline
LPseq::LPseq(char *name) : ( name )
{
    // does thing itself
}


static inline TimeUnit
LPseq::simulatedTime()
{
    return ( TheLPmux -> simulatedTime() );
}

#endif
