#ifndef _LPqueue_h_
#define _LPqueue_h_

#include "LPseq.h"
#include "Random.h"
#include "LPmsgptr.XPQueue.h"

//
// An LPqueue accepts messages and and spits them out the other end
// after some period of time, recording the utilization of the 
// queue.
//

class LPqueue : public LPseq {
public:

    TimeClock record;
    LPmsgptrXPQueue queue;
    bool itemInQueue;

    LP *pSource;
    int pSourceOutput;
    LP *pSink;
    int pSinkInput;

    LPqueue( char *name = "" );

    //
    // wire returns output port for source
    //
    virtual void wire(LP *source, LP *sink);

    virtual void action( LPmsg* what);

    virtual TimeUnit computeDelay( LPmsg *what );
};

extern char *isALPqueueMsg;
class LPqueueMsg : public LPmsg {
public:
    virtual const char *isA();
    LPmsg *divertedMessage;

};

static inline
LPqueue::LPqueue(char *name, Random *svc) : ( name )
{
    serviceInterval = svc;
}


static inline TimeUnit
LPqueue::simulatedTime()
{
    return ( TheLPmux -> simulatedTime() );
}

#endif
