#ifndef _LPmux_h_
#define _LPmux_h_

#include "LPmsgptr.SplayPQ.h"

class LPmux;

extern LPmux *TheLPmux;

class LPmux {
    LPmsgptrSplayPQ events;

    TimeUnit CurrentSimulatedTime;

    int pDirectCalls;
    int max;

public:
    
    LPmux();
    virtual ~LPmux();

    TimeUnit simulatedTime();

    int directCallOk();
    void directCall();

    //
    // schedule a message - doesn't do much else...
    //
    void add(LPmsg*);
    void fireItUp();
}; 

static inline TimeUnit
LPmux::simulatedTime()
{
    return ( CurrentSimulatedTime );
}

static inline void
LPmux::add(LPmsgptr what)
{
    events.enq(what);
    int x = events.length();
    if ( max < x ) {
	max = x;
    }
}

static inline int
LPmux::directCallOk()
{
    //
    // Limit the number of direct calls allowed (stack depth, basically)
    //
    return( events.empty() && pDirectCalls < 30 );
}

static inline void
LPmux::directCall()
{
    pDirectCalls++;
}

#endif
