// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/


#ifndef _LPmsgptrQueue_h
#ifdef __GNUG__
#pragma once
#pragma interface
#endif
#define _LPmsgptrQueue_h

#include <builtin.h>

#include "LPmsgptr.defs.h"

class LPmsgptrQueue
{
public:
                        LPmsgptrQueue();
  virtual              ~LPmsgptrQueue();

  virtual void          enq(LPmsgptr  item) = 0;
  virtual LPmsgptr           deq() = 0;
  virtual LPmsgptr&          front() = 0;
  virtual void          del_front() = 0;

  virtual void          clear() = 0;
  virtual int           empty() = 0;
  virtual int           full() = 0;
  virtual int           length() = 0;

  void                  error(const char*);
  
  virtual int           OK() = 0;
};

#if defined(__OPTIMIZE__) || defined(USE_LIBGXX_INLINES)

inline LPmsgptrQueue::LPmsgptrQueue() {}

#endif
#endif
