// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/


#ifndef _LPmsgSplayPQ_h
#pragma once
#define _LPmsgSplayPQ_h 1

#include "LPmsg.PQ.h"

#ifndef _LPmsgSplayNode
#define _LPmsgSplayNode 1

struct LPmsgSplayNode
{
  LPmsgSplayNode*   lt;
  LPmsgSplayNode*   rt;
  LPmsgSplayNode*   par;
  LPmsg             item;
                  LPmsgSplayNode(LPmsg& h, LPmsgSplayNode* l=0, LPmsgSplayNode* r=0);
                  ~LPmsgSplayNode();
};


inline LPmsgSplayNode::LPmsgSplayNode(LPmsg& h, LPmsgSplayNode* l=0, LPmsgSplayNode* r=0)
{
  item = h;
  lt = l;
  rt = r;
  par = 0;
}

inline LPmsgSplayNode::~LPmsgSplayNode() {}

typedef LPmsgSplayNode* LPmsgSplayNodePtr;

#endif

class LPmsgSplayPQ : public LPmsgPQ
{
protected:
  LPmsgSplayNode*   root;

  LPmsgSplayNode*   leftmost();
  LPmsgSplayNode*   rightmost();
  LPmsgSplayNode*   pred(LPmsgSplayNode* t);
  LPmsgSplayNode*   succ(LPmsgSplayNode* t);
  void            _kill(LPmsgSplayNode* t);
  LPmsgSplayNode*   _copy(LPmsgSplayNode* t);

public:
                  LPmsgSplayPQ();
                  LPmsgSplayPQ(LPmsgSplayPQ& a);
                  ~LPmsgSplayPQ();

  Pix           enq(LPmsg& item);
  LPmsg           deq(); 

  LPmsg&          front();
  void          del_front();

  int           contains(LPmsg& item);

  void          clear(); 

  Pix           first(); 
  Pix           last(); 
  void          next(Pix& i);
  void          prev(Pix& i);
  LPmsg&          operator () (Pix i);
  void          del(Pix i);
  Pix           seek(LPmsg& item);

  int           OK();                    // rep invariant
};

inline LPmsgSplayPQ::~LPmsgSplayPQ()
{
  _kill(root);
}

inline LPmsgSplayPQ::LPmsgSplayPQ()
{
  root = 0;
  count = 0;
}

inline LPmsgSplayPQ::LPmsgSplayPQ(LPmsgSplayPQ& b)
{
  count = b.count;
  root = _copy(b.root);
}

inline Pix LPmsgSplayPQ::first()
{
  return Pix(leftmost());
}

inline Pix LPmsgSplayPQ::last()
{
  return Pix(rightmost());
}

inline void LPmsgSplayPQ::next(Pix& i)
{
  if (i != 0) i = Pix(succ((LPmsgSplayNode*)i));
}

inline void LPmsgSplayPQ::prev(Pix& i)
{
  if (i != 0) i = Pix(pred((LPmsgSplayNode*)i));
}

inline LPmsg& LPmsgSplayPQ::operator () (Pix i)
{
  if (i == 0) error("null Pix");
  return ((LPmsgSplayNode*)i)->item;
}

inline void LPmsgSplayPQ::clear()
{
  _kill(root);
  count = 0;
  root = 0;
}

inline int LPmsgSplayPQ::contains(LPmsg& key)
{
  return seek(key) != 0;
}


#endif
