// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/


#ifndef _LPmsgPQ_h
#pragma once
#define _LPmsgPQ_h 1

#include <Pix.h>
#include "LPmsg.defs.h"

class LPmsgPQ
{
protected:

  int                   count;

public:
  int                   length();                // current number of items
  int                   empty();

  virtual Pix           enq(LPmsg& item) = 0;      // add item; return Pix
  virtual LPmsg           deq();                   // return & remove min

  virtual LPmsg&          front() = 0;             // access min item
  virtual void          del_front() = 0;         // delete min item

  virtual int           contains(LPmsg& item);     // is item in PQ?

  virtual void          clear();                 // delete all items

  virtual Pix           first() = 0;             // Pix of first item or 0
  virtual void          next(Pix& i) = 0;        // advance to next or 0
  virtual LPmsg&          operator () (Pix i) = 0; // access item at i
  virtual void          del(Pix i) = 0;          // delete item at i
  virtual int           owns(Pix i);             // is i a valid Pix  ?
  virtual Pix           seek(LPmsg& item);         // Pix of item

  void                  error(const char* msg);
  virtual int           OK() = 0;                // rep invariant
};


inline int LPmsgPQ::length()
{
  return count;
}

inline int LPmsgPQ::empty()
{
  return count == 0;
}


#endif
