
#ifdef __GNUG__
#  pragma implementation
#endif

#include "CpuMultiplexor.h"
#include "CpuMultiplexorP.h"
#include "Thread.h"
#include "ThreadContainer.h"
#include "assert.h"

const void * UNINITIALIZED = 0;

Thread::Thread(char* name, unsigned stacksize,
	       int checkStack,
	       ThreadPriority priority, bool xdebug)
    : (xdebug), pContext(checkStack, stacksize)
{
    threadName = name;
    threadPriority = priority;
    threadState = RUNNABLE;
    cpuAffinity = -1;

    pContext.buildReturnFrame(this, voidFuncP(&Thread::startOff));

    if (debugFlag) {
	cerr << "[create Thread " << name << " at " << hex(long(this)) << "\n";
    }
    
}

Thread::~Thread()
{
    makeTerminated();
    //
    //	The destructor for HardwareContext doesn't free the stack space.
    //  If a thread other than the this thread is calling the destructor,
    //  we need to reclaim that stack space now.
    //
    //  If the current thread is calling the destructor, it must do so
    //  by returning from main & the via the delete statement in startOff.
    //  In that case, we delete the stack in startOff.
    //
    //  It is considered an error for this thread to delete itself in any
    //  other way (i.e. you can do it, but don't complain about what happens).
    //
    if ( this != CurrentThread() ) {
	pContext.reclaimStack();
    }
}

void Thread::main()
{
    assert2(FALSE, "[Thread] Subclass of thread forgot to specialize main()");
}

void
Thread::startOff()
{
    main();
    void **p = pContext.mallocAt();
    ThisCpu -> threadTerminateException( this );
    assert2(FALSE,"[Thread] Thread exits main");
}

void Thread::makeTerminated()
{
    //
    //	this doesn't do anything yet. It's not clear it's needed either,
    //  since most termination-oriented things could happen in the
    //  destructor.
    //
}

void Thread::classPrintOn(ostream& strm)
{
    strm << "[Thread:"
	 << " " << threadName
         << "  pri: " << int(threadPriority)
         << "  state: ";
    switch (threadState) {
    case SUSPENDED:
	strm << "SUSPENDED";
	break;
    case RUNNING:
	strm << "RUNNING";
	break;
    case RUNNABLE:
	strm << "RUNNABLE";
	break;
    case TERMINATED:
	strm << "TERMINATED";
	break;

    case ZOMBIED:
    default: strm << "INVALID";
	break;
    }
    strm << "]\n";
    strm << pContext << "\n";;
}
