#ifndef SingleCpuMux_h
#define SingleCpuMux_h

#ifdef __GNUG__
#  pragma once
#  pragma interface
#endif

#include <CpuMultiplexor.h>
class ThreadContainer;

class SingleCpuMux : public CpuMultiplexor {
    friend class SingleSimMux;

    ThreadContainer *myCurrentEvents;

public:
    SingleCpuMux(int debug = 0);
    virtual ~SingleCpuMux();

    virtual void fireItUp(int Cpus = 1, unsigned shared = (4196 * 500));
    virtual void warmThePot(int);
    virtual void stirItAround();
    virtual void coolItDown();

    virtual void add(Thread *);
};

//
//	These are things the user needs to define
//

extern ThreadContainer *AllocateHardwareCurrentEventsStructure();

#endif /* SingleCpuMux_h */
