
#ifdef __GNUG__
#  pragma implementation
#endif

#include "SingleCpuMux.h"
#include "CpuMultiplexorP.h"
#include "SpinLock.h"
#include "SpinFetchAndOp.h"
#include "Thread.h"
#include "ThreadContainer.h"
#include "ReserveByException.h"
#include <math.h>

//
//	This can not be private, or we wont see all the action
//
extern int CpuMuxDebugFlag;

SingleCpuMux::SingleCpuMux(int debug) : (debug)
{
    CpuMuxDebugFlag = debug;
    pNameTemplate = "SingleCpuMux";
    iYam = 0;
    sprintf(nameSpace, "[%s-%d] ", pNameTemplate, iYam);
    pName = nameSpace;
    myCurrentEvents = AllocateHardwareCurrentEventsStructure();
}

SingleCpuMux::~SingleCpuMux()
{
    delete myCurrentEvents;
    myCurrentEvents = 0;
}

void
SingleCpuMux::fireItUp(int, unsigned)
{
    warmThePot(1);
    stirItAround();
    coolItDown();
}

void
SingleCpuMux::warmThePot(int)
{
    pid = getpid();
    enabled = 1;
}

void
SingleCpuMux::coolItDown()
{
    // empty
}

void
SingleCpuMux::add(Thread *who)
{
    myCurrentEvents -> add( who );
}

//
// This is the job dispatcher.
//

void
SingleCpuMux::stirItAround()
{
    currentThread = 0;

    while( ! *terminated ) {
	currentThread = myCurrentEvents -> remove();
	if (currentThread == 0 ) {
	    return;
	}
	systemContext.switchContext(&(currentThread -> pContext));
	raisedBy -> handleException();
	raisedBy = 0;
    }
}
