#ifndef CpuMuxExceptions_h
#define CpuMuxExceptions_h

#ifdef __GNUG__
#  pragma once
#  pragma interface
#endif

#include <ExceptionClass.h>

//
//	ExceptionByReserve -- Used to reserve a semaphore/barrier/etc
//
class ReserveByException;

class ExceptionReserve : public ExceptionClass {
    ReserveByException *toReserve;
public:
    ReserveByException *reserve();
    void reserve(ReserveByException *);
    
    virtual void handleException();
};

static inline ReserveByException *
ExceptionReserve::reserve()
{
    return(toReserve);
}

static inline void
ExceptionReserve::reserve(ReserveByException *r)
{
    toReserve = r;
}


//
//	ExceptionTerminate -- used to terminate a thread
//
class Thread;

class ExceptionTerminate : public ExceptionClass {
    Thread *deadThread; 
public:
    void terminate(Thread *);
    virtual void handleException();
};

static inline void
ExceptionTerminate::terminate(Thread *r)
{
    deadThread = r;
}

//
//	ExceptionReschedule -- used to relenquish the CPU.
//

class ExceptionReschedule : public ExceptionClass {
public:
    virtual void handleException();
};

//
//	ExceptionIveSuspended -- used when current thread has suspended
//	itself and another thread must be scheduled and run.
//

class ExceptionIveSuspended : public ExceptionClass {
public:
    virtual void handleException();
};

#endif /* CpuMuxExceptions_h */
