
#ifdef __GNUG__
#  pragma implementation
#endif

#include "CpuMuxExceptions.h"
#include "ReserveByException.h"
#include "CpuMultiplexor.h"
#include "SpinBarrier.h"
#include "stream.h"
#include "Thread.h"

void
ExceptionReserve::handleException()
{
    if ( toReserve -> reserveByException( ThisCpu -> currentThread ) ) {
	ThisCpu -> currentThread = 0;
    }
}

void
ExceptionTerminate::handleException()
{
    ThisCpu -> currentThread = 0; // do before delete so thread frees stack
    delete deadThread;
}

void
ExceptionReschedule::handleException()
{
    //
    // Switch to another thread when we havenot gotten
    // rid of the current one.
    //
    assert(ThisCpu -> currentThread != 0);
    ThisCpu -> add( ThisCpu -> currentThread );
    ThisCpu -> currentThread = 0;
}

void
ExceptionIveSuspended::handleException()
{
    //
    // Switch to another thread when we havenot gotten
    // rid of the current one.
    //
    ThisCpu -> currentThread = 0;
}
