
#ifdef __GNUG__
#  pragma implementation
#endif

#include "CpuMultiplexor.h"
#include "CpuMultiplexorP.h"
#include "Thread.h"
#include "ReserveByException.h"
#include "SpinLock.h"
#include <math.h>

static const int NOTREACHED = 0;

int CpuMultiplexors;
CpuMultiplexor *ThisCpu;
SpinLock CpuCerrLock;

//
//	This can not be private, or we wont see all the action
//

static int StopCpuMux;

int CpuMuxDebugFlag = 0;

CpuMultiplexor::CpuMultiplexor(int debug) : systemContext(0, 0)
{
    pNameTemplate = "CpuMux";
    currentThread = 0;
    enabled = 0;
    iYam = 0;
    pid = 0;
    CpuMuxDebugFlag = debug;
    ThisCpu = this;
    terminated = &StopCpuMux;
    sprintf(nameSpace, "[%s-%d] ", pNameTemplate, iYam);
    pName = nameSpace;
}

CpuMultiplexor::~CpuMultiplexor()
{
    // empty
}

void
CpuMultiplexor::debug(int newdebug)
{
    CpuMuxDebugFlag = newdebug;
}

int
CpuMultiplexor::debug()
{
    return(CpuMuxDebugFlag);
}

void
CpuMultiplexor::terminateAll()
{
    StopCpuMux = 1;
}


void
CpuMultiplexor::fireItUp(int, unsigned)
{
    assert( NOTREACHED );
}

void
CpuMultiplexor::warmThePot(int)
{
    assert( NOTREACHED );
}

void
CpuMultiplexor::coolItDown()
{
    assert( NOTREACHED );
}

void
CpuMultiplexor::add(Thread*)
{
    assert( NOTREACHED );
}

//
// This is the job dispatcher.
//

void
CpuMultiplexor::stirItAround()
{
    assert( NOTREACHED );
}

void
CpuMultiplexor::flick()
{
    currentThread -> cpuAffinity = -1;
    raise( &rescheduleException ); 
}
