#ifndef AWESIMEH
#define AWESIMEH

#ifdef __GNUG__
#  pragma once
#  pragma interface
#endif

//
//	Awesime.h
//
//	Awesime is a component of the Discret Event Simulation Environment.
//	The major purpose of Awesime is to provide a virtual function
//	resetInternalState which is used to reset a simulation.
//	In addition, each Awesime can provide a function 'reportState' which
//	lists the current state of that simulation component in a standard
//	format.
//
//	These virtuals are used to implement Resetables and Reportables,
//	and the Awesime serves to define a simulation environment.
// 

#include <stream.h>
#include <std.h>
#include <bool.h>

class Awesime;
typedef Awesime *AwesimePtr;
typedef void *VoidPtr;

class Awesime {
protected:
    int debugFlag;

public :

    Awesime(bool xdebug = 0);

    virtual bool debug();
    virtual bool debug(bool x);

    virtual void classPrintOn(ostream& s);
    virtual void subClassResponsibility(char *name = "");
};

static inline
Awesime::Awesime(bool xdebug)
{
    debugFlag = xdebug;
}

inline ostream&
operator<<(ostream& strm, Awesime& ob)
{
    ob.classPrintOn(strm);
    return strm;
}

#endif AWESIME
