#include <stream.h>
#include <sys/types.h>
/*
 * sys/socket.h provides prototypes for connect & accept and
 * also declares them as extern "C"
 */
#include <sys/socket.h>
#include <std.h>

#include "Async.h"

#ifdef DEBUG
static char *itoa( int Num, int *len )
{
#define NUMBUF_SIZE     15
   static char numbuf[ NUMBUF_SIZE ] ;
   register char *p = &numbuf[ NUMBUF_SIZE ] ;
   unsigned num = (unsigned) Num ;

   *--p = '\0' ;
   do
   {
      *--p = num % 10 + '0' ;
      num /= 10 ;
   }
   while ( num ) ;
   *len = &numbuf[ NUMBUF_SIZE ] - p - 1 ;
   return( p ) ;
}
#endif


int read( int fd, void *buf, unsigned nbytes )
{
	AsyncIO::ioInit() ;
	int status = asyncIO_array[ fd ].read( fd, buf, nbytes ) ;
#ifdef DEBUG
	if ( status == -1 )
		syscall( SYS_write, 2, "GOT -1\n", 7 ) ;
	else
	{
		int len ;
		char *numstr = itoa( status, &len ) ;
		syscall( SYS_write, 2, numstr, len ) ;
		syscall( SYS_write, 2, buf, status ) ;
	}
#endif
	return( status ) ;

}


int write( int fd, const void *buf, unsigned nbytes )
{
	AsyncIO::ioInit() ;
	int status = asyncIO_array[ fd ].write( fd, buf, nbytes ) ;
	return( status ) ;
}


/*
 * The only reason for masking close is to have the fin function
 * for the particular fd called
 */
int close( int fd )
{
	AsyncIO::ioInit() ;
	asyncIO_array[ fd ].fin() ;
	return( syscall( SYS_close, fd ) ) ;
}


int connect( int fd, struct sockaddr *name, int namelen )
{
	AsyncIO::ioInit() ;
	return( asyncIO_array[ fd ].connect( fd, name, namelen ) ) ;
}


int accept( int fd, struct sockaddr *name, int *namelen )
{
	AsyncIO::ioInit() ;
	return( asyncIO_array[ fd ].accept( fd, name, namelen ) ) ;
}


int send( int fd, char *msg, int len, int flags )
{
	AsyncIO::ioInit() ;
	return( asyncIO_array[ fd ].send( fd, msg, len, flags ) ) ;
}


int sendto( int fd, char *msg, int len, int flags,
				struct sockaddr *to, int tolen )
{
	AsyncIO::ioInit() ;
	return( asyncIO_array[ fd ].sendto( fd, msg, len, flags, to, tolen ) ) ;
}


int sendmsg( int fd, struct msghdr *msg, int flags )
{
	AsyncIO::ioInit() ;
	return( asyncIO_array[ fd ].sendmsg( fd, msg, flags ) ) ;
}


int recv( int fd, char *buf, int len, int flags )
{
	AsyncIO::ioInit() ;
	return( asyncIO_array[ fd ].recv( fd, buf, len, flags ) ) ;
}


int recvfrom( int fd, char *buf, int len, int flags,
				struct sockaddr *from, int *fromlen )
{
	AsyncIO::ioInit() ;
	return( asyncIO_array[ fd ].recvfrom( fd, buf, len, flags,
							from, fromlen ) ) ;
}


int recvmsg( int fd, struct msghdr *msg, int flags )
{
	AsyncIO::ioInit() ;
	return( asyncIO_array[ fd ].recvmsg( fd, msg, flags ) ) ;
}

