#include <stream.h>

#include "CpuMultiplexor.h"
#include "CpuMultiplexorP.h"
#include "MultiCpuMux.h"

#include "MultiAsync.h"


static inline void MultiAsyncIO::switchTo()
{
	Thread *current = ThisCpu->CurrentThread() ;
	current->fromCpu = ThisCpu->cpuId() ;

	if ( owner != ThisCpu->cpuId() )
	{
		MultiCpuMux *mCpu = (MultiCpuMux *) ThisCpu ;
		mCpu->relocateException.cpu( owner ) ;
		ThisCpu->raise( &mCpu->relocateException ) ;
	}
}



MultiAsyncIO::read( int fd, void *buf, unsigned nbytes )
{
	switchTo() ;
	int bytesRead = AsyncIO::read( fd, buf, nbytes ) ;
	return( bytesRead ) ;
}


MultiAsyncIO::write( int fd, const void *buf, unsigned nbytes )
{
	switchTo() ;
	int bytesWritten = AsyncIO::write( fd, buf, nbytes ) ;
	return( bytesWritten ) ;
}


/*
 * NOTE: In the case of accept and connect it is possible to have
 *       the new fd in the process where the thread lives instead
 *       of where the accept/connect happened by sending the fd
 *       between processes.
 */
MultiAsyncIO::accept( int fd, struct sockaddr *name, int *namelen )
{
	int duplicateAndAssign( int ) ;

	switchTo() ;
	int acceptedFd = AsyncIO::accept( fd, name, namelen ) ;
	if ( acceptedFd != -1 )
		acceptedFd = duplicateAndAssign( acceptedFd ) ;
	return( acceptedFd ) ;
}


MultiAsyncIO::connect( int fd, struct sockaddr *name, int namelen )
{
	switchTo() ;
	int status = AsyncIO::connect( fd, name, namelen ) ;
	return( status ) ;
}

