#include <stream.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>

#include <bool.h>
#include "MultiAsync.h"
#include "Fd.h"


/*
 * Note that this function may be invoked by more than one cpu
 */
void MultiAsyncIO::ioInit()
{
	void sigioHandler() ;
	
	initLock.reserve() ;
	if ( initialized == NO )
	{
		n_fds = getdtablesize() ;
		multiAsyncIO_array = new MultiAsyncIO[ n_fds ] ;

		for ( int i = 0 ; i < MaxCpuMultiplexors ; i++ )
		{
			FD_ZERO( &readMask[ i ] ) ;
			FD_ZERO( &writeMask[ i ] ) ;
			fdWidth[ i ] = 0 ;
		}

		/*
		 * all fd's open at this point belong to cpu 0
		 */
		for ( i = 0 ; i < n_fds ; i++ )
		{
			struct stat st ;

			if ( fstat( i, &st ) != -1 )
			{
				multiAsyncIO_array[ i ].owner = 0 ;
				ASSERT( fdAllocator.request( i ) != -1 ) ;
			}
		}
		initialized = YES ;
	}
	initLock.release() ;

	if ( ! signalHandlerInstalled[ ThisCpu->cpuId() ] )
	{
		(void) signal( SIGIO, sigioHandler ) ;
		signalHandlerInstalled[ ThisCpu->cpuId() ] = TRUE ;
	}

}


void MultiAsyncIO::reschedule()
{
	while ( ! pileOfThreads.isEmpty )
	{
		Thread *p = (Thread *) pileOfThreads.remove() ;
		if ( p->fromCpu != ThisCpu->cpuId() )
			ThisCpu->addToAnother( fromCpu, p ) ;
		else
			ThisCpu->add( p ) ;
	}
}
